# 機能設計書 F074-勤務地管理

## 概要

本ドキュメントは、AureusERPの人事管理モジュールにおける勤務地管理機能の詳細設計を記述します。勤務地は、従業員が勤務する場所を定義・管理するためのマスタデータです。

### 本機能の処理概要

勤務地管理機能は、組織における勤務場所の情報を定義・維持するための機能です。

**業務上の目的・背景**：企業が複数の事業所、オフィス、リモートワーク拠点を持つ場合、各従業員の勤務場所を明確に管理することが重要です。勤務地を定義することで、通勤手当の計算、勤怠管理、人員配置の把握に活用できます。

**機能の利用シーン**：人事担当者が新しい勤務地を追加する際、既存の勤務地情報を更新する際、または事業所の統廃合時に利用されます。また、従業員の勤務地変更時にも活用されます。

**主要な処理内容**：
1. 勤務地の一覧表示・検索・フィルタリング
2. 新規勤務地の作成（名前、勤務地タイプ、住所、会社）
3. 既存勤務地の編集・更新
4. 勤務地の削除（論理削除）・復元

**関連システム・外部連携**：従業員管理（EmployeeResource）と連携し、従業員の勤務地情報として参照されます。会社（Company）、住所（Partner）とも連携します。

**権限による制御**：管理者権限を持つユーザーのみが勤務地の作成・編集・削除が可能です。一般ユーザーは閲覧のみ可能です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-EMP-013 | WorkLocationResource | 主画面 | 勤務地のCRUD操作 |
| SCR-EMP-001 | EmployeeResource | 参照画面 | 従業員勤務地情報の参照 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 勤務地名 | 最大255文字 |
| work_location_type | enum | No | 勤務地タイプ | LocationType Enumの値（home/office/other） |
| address_id | integer | No | 住所ID | 存在する住所IDを参照 |
| company_id | integer | No | 会社ID | 存在する会社IDを参照 |
| creator_id | integer | Yes | 作成者ID | 認証ユーザーIDが自動設定 |

### 入力データソース

画面フォーム入力（Filament Form）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 勤務地ID |
| name | string | 勤務地名 |
| work_location_type | string | 勤務地タイプ |
| address | object | 住所情報 |
| company | object | 会社情報 |
| createdBy | object | 作成者情報 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

画面表示（Filament Table/Infolist）、データベーステーブル（employees_work_locations）

## 処理フロー

### 処理シーケンス

```
1. ユーザー認証確認
   └─ 未認証の場合はログイン画面へリダイレクト
2. 権限チェック
   └─ 勤務地管理権限の有無を確認
3. 一覧表示処理
   └─ フィルタ・ソート条件に基づきデータ取得
4. CRUD操作
   └─ 作成：バリデーション → 保存 → 通知
   └─ 更新：存在確認 → バリデーション → 保存 → 通知
   └─ 削除：存在確認 → 論理削除 → 通知
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証済み?}
    B -->|No| C[ログイン画面へ]
    B -->|Yes| D{権限確認}
    D -->|権限なし| E[403エラー]
    D -->|権限あり| F[一覧表示]
    F --> G{操作選択}
    G -->|作成| H[入力フォーム表示]
    G -->|編集| I[編集フォーム表示]
    G -->|削除| J[削除確認]
    G -->|表示| K[詳細表示]
    H --> L{バリデーション}
    I --> L
    L -->|OK| M[DB保存]
    L -->|NG| N[エラー表示]
    M --> O[成功通知]
    J --> P[論理削除]
    P --> O
    O --> F
    K --> F
    N --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-074-01 | 論理削除 | 削除時は論理削除（SoftDeletes） | 削除操作時 |
| BR-074-02 | 作成者自動設定 | 作成者は認証ユーザーが自動設定 | 新規作成時 |
| BR-074-03 | 勤務地タイプ分類 | home/office/otherの3分類 | 新規作成・更新時 |
| BR-074-04 | 削除済み会社表示 | 削除済み会社は選択肢に表示されるが選択不可 | 会社選択時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | employees_work_locations | SELECT | 勤務地一覧の取得 |
| 詳細取得 | employees_work_locations | SELECT | 単一勤務地の取得 |
| 作成 | employees_work_locations | INSERT | 新規勤務地の登録 |
| 更新 | employees_work_locations | UPDATE | 勤務地情報の更新 |
| 削除 | employees_work_locations | UPDATE | 論理削除（deleted_at更新） |
| 復元 | employees_work_locations | UPDATE | 復元（deleted_at = NULL） |

### テーブル別操作詳細

#### employees_work_locations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | ユーザー入力値 | 必須 |
| INSERT | work_location_type | ユーザー選択値 | 任意 |
| INSERT | address_id | ユーザー選択値 | 任意 |
| INSERT | company_id | ユーザー選択値 | 任意 |
| INSERT | creator_id | 認証ユーザーID | 自動設定 |
| UPDATE | deleted_at | 現在日時 | 削除時 |
| UPDATE | deleted_at | NULL | 復元時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-074-01 | バリデーションエラー | 名前未入力 | エラーメッセージ表示 |
| E-074-02 | 認証エラー | 未ログイン状態 | ログイン画面へリダイレクト |
| E-074-03 | 権限エラー | 操作権限なし | 403エラーページ表示 |
| E-074-04 | 存在エラー | 対象レコード不存在 | 404エラーページ表示 |

### リトライ仕様

データベース接続エラー時は自動リトライ（Laravel標準機能）

## トランザクション仕様

単一テーブル操作のため、個別操作ごとのトランザクション管理（Laravel Eloquent標準）

## パフォーマンス要件

- 一覧取得：1秒以内
- 単一操作（CRUD）：500ms以内
- ページネーション：15件/ページ

## セキュリティ考慮事項

- 認証必須（Filament認証）
- CSRF対策（Laravel標準）
- XSS対策（Blade自動エスケープ）
- 権限制御（Filament Shield）

## 備考

- Filament v3を使用したリソース管理
- SoftDeletesトレイトによる論理削除対応
- LocationType Enumによる勤務地タイプ分類（home/office/other）
- 住所はPartnerモデルを参照（sub_type = 'company'のレコード）
