# 機能設計書 F077-活動プラン管理(人事)

## 概要

本ドキュメントは、AureusERPの人事管理モジュールにおける活動プラン管理機能の詳細設計を記述します。活動プランは、従業員に対する定期的な活動・タスクを計画・管理するための機能です。

### 本機能の処理概要

活動プラン管理機能は、人事部門が従業員に対して実施する定期活動（研修、面談、評価等）を計画・管理するための機能です。

**業務上の目的・背景**：企業における人材育成・管理において、計画的な活動実施は重要です。オンボーディング、定期面談、スキル研修など、従業員に対する活動を体系的に管理することで、人材育成の効率化、コンプライアンス対応に活用できます。

**機能の利用シーン**：人事担当者が新入社員向けオンボーディングプランを作成する際、定期評価面談のスケジュールを設定する際、または部門別の研修計画を策定する際に利用されます。

**主要な処理内容**：
1. 活動プランの一覧表示・検索・フィルタリング
2. 新規活動プランの作成（名前、部門、会社、有効/無効状態）
3. 既存活動プランの編集・更新
4. 活動プランの削除（論理削除）・復元
5. 活動プランに紐づく活動テンプレートの管理

**関連システム・外部連携**：部門管理（DepartmentResource）、会社管理（CompanyResource）、活動タイプ管理と連携し、組織構造に基づいた活動計画を実現します。

**権限による制御**：管理者権限を持つユーザーのみが活動プランの作成・編集・削除が可能です。一般ユーザーは閲覧のみ可能です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-EMP-012 | ActivityPlanResource | 主画面 | 活動プランのCRUD操作 |
| SCR-EMP-002 | DepartmentResource | 参照画面 | 部門情報の参照 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | プラン名 | 最大255文字 |
| department_id | integer | No | 部門ID | 存在する部門IDを参照 |
| company_id | integer | No | 会社ID | 存在する会社IDを参照 |
| is_active | boolean | No | 有効/無効フラグ | デフォルト: true |
| plugin | string | Yes | プラグイン識別子 | 自動設定: 'employees' |
| creator_id | integer | Yes | 作成者ID | 認証ユーザーIDが自動設定 |

### 入力データソース

画面フォーム入力（Filament Form）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | プランID |
| name | string | プラン名 |
| department | object | 部門情報 |
| company | object | 会社情報 |
| is_active | boolean | 有効/無効状態 |
| activityTemplates | array | 活動テンプレート一覧 |
| createdBy | object | 作成者情報 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

画面表示（Filament Table/Infolist）、データベーステーブル（activity_plans）

## 処理フロー

### 処理シーケンス

```
1. ユーザー認証確認
   └─ 未認証の場合はログイン画面へリダイレクト
2. 権限チェック
   └─ 活動プラン管理権限の有無を確認
3. 一覧表示処理
   └─ plugin='employees'でフィルタリングされたデータを取得
4. CRUD操作
   └─ 作成：バリデーション → plugin設定 → 保存 → 通知
   └─ 更新：存在確認 → バリデーション → 保存 → 通知
   └─ 削除：存在確認 → 論理削除 → 通知
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証済み?}
    B -->|No| C[ログイン画面へ]
    B -->|Yes| D{権限確認}
    D -->|権限なし| E[403エラー]
    D -->|権限あり| F[一覧表示]
    F --> G{操作選択}
    G -->|作成| H[入力フォーム表示]
    G -->|編集| I[編集フォーム表示]
    G -->|削除| J[削除確認]
    G -->|表示| K[詳細表示]
    H --> L{バリデーション}
    I --> L
    L -->|OK| M[plugin='employees'設定]
    M --> N[DB保存]
    L -->|NG| O[エラー表示]
    N --> P[成功通知]
    J --> Q[論理削除]
    Q --> P
    P --> F
    K --> F
    O --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-077-01 | 論理削除 | 削除時は論理削除（SoftDeletes） | 削除操作時 |
| BR-077-02 | 作成者自動設定 | 作成者は認証ユーザーが自動設定 | 新規作成時 |
| BR-077-03 | プラグイン識別子 | plugin='employees'が自動設定される | 新規作成時 |
| BR-077-04 | プラグインフィルタ | 一覧はplugin='employees'でフィルタリング | 一覧表示時 |
| BR-077-05 | デフォルト会社設定 | 会社未指定時はユーザーのデフォルト会社を設定 | 新規作成時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | activity_plans | SELECT | plugin='employees'でフィルタリングされた活動プラン一覧の取得 |
| 詳細取得 | activity_plans | SELECT | 単一活動プランの取得 |
| 作成 | activity_plans | INSERT | 新規活動プランの登録 |
| 更新 | activity_plans | UPDATE | 活動プラン情報の更新 |
| 削除 | activity_plans | UPDATE | 論理削除（deleted_at更新） |
| 復元 | activity_plans | UPDATE | 復元（deleted_at = NULL） |

### テーブル別操作詳細

#### activity_plans

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | plugin | = 'employees' | フィルタ条件 |
| INSERT | name | ユーザー入力値 | 必須 |
| INSERT | department_id | ユーザー選択値 | 任意 |
| INSERT | company_id | ユーザー選択値またはデフォルト会社 | 任意 |
| INSERT | is_active | ユーザー選択値（デフォルト: true） | |
| INSERT | plugin | 'employees' | 自動設定 |
| INSERT | creator_id | 認証ユーザーID | 自動設定 |
| UPDATE | deleted_at | 現在日時 | 削除時 |
| UPDATE | deleted_at | NULL | 復元時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-077-01 | バリデーションエラー | 名前未入力 | エラーメッセージ表示 |
| E-077-02 | 認証エラー | 未ログイン状態 | ログイン画面へリダイレクト |
| E-077-03 | 権限エラー | 操作権限なし | 403エラーページ表示 |
| E-077-04 | 存在エラー | 対象レコード不存在 | 404エラーページ表示 |

### リトライ仕様

データベース接続エラー時は自動リトライ（Laravel標準機能）

## トランザクション仕様

単一テーブル操作のため、個別操作ごとのトランザクション管理（Laravel Eloquent標準）

## パフォーマンス要件

- 一覧取得：1秒以内
- 単一操作（CRUD）：500ms以内
- ページネーション：15件/ページ

## セキュリティ考慮事項

- 認証必須（Filament認証）
- CSRF対策（Laravel標準）
- XSS対策（Blade自動エスケープ）
- 権限制御（Filament Shield）

## 備考

- Filament v3を使用したリソース管理
- SoftDeletesトレイトによる論理削除対応
- 共通のActivityPlanモデルをplugin='employees'でフィルタリングして使用
- ActivityTemplateRelationManagerによる活動テンプレートの管理
- 部門マネージャーの情報も一覧表示で確認可能
- 削除済み会社は選択肢に表示されるが選択不可
