# 機能設計書 F078-従業員スキルレポート

## 概要

本ドキュメントは、AureusERPの人事管理モジュールにおける従業員スキルレポート機能の詳細設計を記述します。従業員スキルレポートは、組織内の従業員が保有するスキル情報を横断的に閲覧・分析するためのレポーティング機能です。

### 本機能の処理概要

従業員スキルレポート機能は、組織全体の従業員スキル情報を集約・表示するレポーティング機能です。

**業務上の目的・背景**：企業における人材活用において、従業員のスキル情報を横断的に把握することは重要です。組織全体のスキル分布、スキルレベル別の人員構成、特定スキル保有者の検索など、戦略的人材配置やスキルギャップ分析に活用できます。

**機能の利用シーン**：人事担当者がプロジェクトへの人員配置を検討する際、特定スキルを持つ従業員を検索する際、または組織全体のスキル分布を把握する際に利用されます。

**主要な処理内容**：
1. 従業員スキルの一覧表示・検索・フィルタリング
2. スキルタイプ別・スキルレベル別のグルーピング
3. 従業員名、スキル名、スキルレベル、スキルタイプでの検索
4. 詳細情報の表示（閲覧専用）

**関連システム・外部連携**：従業員管理（EmployeeResource）、スキル管理（SkillResource）、スキルタイプ管理（SkillTypeResource）と連携し、スキル情報を集約表示します。

**権限による制御**：管理者および人事担当者権限を持つユーザーがレポートを閲覧可能です。編集機能は提供されません。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-EMP-007 | EmployeeSkillResource | 主画面 | 従業員スキルレポートの表示 |
| SCR-EMP-001 | EmployeeResource | 参照画面 | 従業員詳細への遷移 |
| SCR-EMP-004 | SkillTypeResource | 参照画面 | スキルタイプ情報の参照 |

## 機能種別

レポート参照（Read Only）

## 入力仕様

### 入力パラメータ

本機能は閲覧専用のため、データ登録・更新のための入力パラメータはありません。

### フィルタパラメータ

| パラメータ名 | 型 | 必須 | 説明 | フィルタ種別 |
|-------------|-----|-----|------|-------------|
| employee | relationship | No | 従業員でフィルタ | SelectFilter |
| skill | relationship | No | スキルでフィルタ | SelectFilter |
| skill_level | relationship | No | スキルレベルでフィルタ | SelectFilter |
| skill_type | relationship | No | スキルタイプでフィルタ | SelectFilter |
| created_by | relationship | No | 作成者でフィルタ | QueryBuilder |
| created_at | date | No | 作成日でフィルタ | DateConstraint |

### 入力データソース

画面フィルタ入力（Filament Filter）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | レコードID |
| employee.name | string | 従業員名 |
| skill.name | string | スキル名 |
| skillLevel.name | string | スキルレベル名 |
| skillLevel.level | integer | スキルレベル値（熟練度%） |
| skillType.name | string | スキルタイプ名 |
| createdBy.name | string | 作成者名 |
| employee.user.name | string | ユーザー名 |
| created_at | datetime | 作成日時 |

### 出力先

画面表示（Filament Table/Infolist）

## 処理フロー

### 処理シーケンス

```
1. ユーザー認証確認
   └─ 未認証の場合はログイン画面へリダイレクト
2. 権限チェック
   └─ レポート閲覧権限の有無を確認
3. 一覧表示処理
   └─ フィルタ・ソート・グループ条件に基づきデータ取得
4. 詳細表示
   └─ 選択された従業員スキルの詳細情報を表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証済み?}
    B -->|No| C[ログイン画面へ]
    B -->|Yes| D{権限確認}
    D -->|権限なし| E[403エラー]
    D -->|権限あり| F[一覧表示]
    F --> G{フィルタ/グループ選択}
    G --> H[データ再取得]
    H --> F
    F --> I{詳細表示?}
    I -->|Yes| J[詳細画面表示]
    I -->|No| K[操作待機]
    J --> F
    K --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-078-01 | 閲覧専用 | データの作成・更新・削除は不可 | 全操作時 |
| BR-078-02 | デフォルトグルーピング | 従業員名でグルーピング表示 | 一覧表示時 |
| BR-078-03 | デフォルトソート | 作成日時の降順でソート | 一覧表示時 |
| BR-078-04 | スキルレベル色分け | Beginner:gray, Intermediate:warning, Advanced:success, Expert:primary | 一覧表示時 |
| BR-078-05 | 熟練度バー表示 | スキルレベル値をプログレスバーで視覚化 | 一覧表示時 |

### 計算ロジック

- 熟練度% = skillLevel.level（0-100の値）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | employees_employee_skills | SELECT | 従業員スキル一覧の取得 |
| 詳細取得 | employees_employee_skills | SELECT | 単一従業員スキルの取得 |

### テーブル別操作詳細

#### employees_employee_skills

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | employee_id | リレーション結合 | 従業員情報 |
| SELECT | skill_id | リレーション結合 | スキル情報 |
| SELECT | skill_level_id | リレーション結合 | スキルレベル情報 |
| SELECT | skill_type_id | リレーション結合 | スキルタイプ情報 |
| SELECT | creator_id | リレーション結合 | 作成者情報 |
| SELECT | created_at | ソート条件 | 降順 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-078-01 | 認証エラー | 未ログイン状態 | ログイン画面へリダイレクト |
| E-078-02 | 権限エラー | 閲覧権限なし | 403エラーページ表示 |
| E-078-03 | 存在エラー | 対象レコード不存在 | 404エラーページ表示 |

### リトライ仕様

データベース接続エラー時は自動リトライ（Laravel標準機能）

## トランザクション仕様

読み取り専用のため、トランザクション管理は不要

## パフォーマンス要件

- 一覧取得：2秒以内（大量データ想定）
- ページネーション対応
- カラム並び替え対応
- 列管理（表示/非表示切り替え）対応

## セキュリティ考慮事項

- 認証必須（Filament認証）
- 権限制御（Filament Shield）
- 従業員情報のアクセス制限

## 備考

- Filament v3を使用したレポーティング画面
- ProgressBarEntryカスタムコンポーネントによる熟練度可視化
- 複数のグルーピングオプション（従業員別、スキルタイプ別）
- 高度なフィルタリング機能（QueryBuilder）によるデータ抽出
- スキルレベルに応じた色分け表示でスキル習熟度を視覚化
- スラッグは 'employees/skills' として定義
