# 機能設計書 F079-応募者管理

## 概要

本ドキュメントは、AureusERPの採用管理モジュールにおける応募者管理機能の詳細設計を記述します。応募者管理は、求人に対する応募者の情報を管理し、採用プロセス全体を追跡するための機能です。

### 本機能の処理概要

応募者管理機能は、採用活動における応募者情報の登録・管理・選考プロセス追跡を行うための中核機能です。

**業務上の目的・背景**：企業の採用活動において、応募者情報の一元管理と選考状況の追跡は不可欠です。応募受付から選考、採用決定、入社までのプロセスを可視化し、効率的な採用活動を実現します。

**機能の利用シーン**：採用担当者が新規応募者を登録する際、選考ステージを更新する際、面接官をアサインする際、または採用/不採用の決定を記録する際に利用されます。

**主要な処理内容**：
1. 応募者の一覧表示・検索・フィルタリング・グルーピング
2. 新規応募者の登録（候補者情報、求人、リクルーター、面接官）
3. 選考ステージの更新（ProgressStepper）
4. 応募者評価（星評価: Good/Very Good/Excellent）
5. 採用決定処理（Hired）
6. 不採用処理（Refused）と不採用理由の記録
7. アーカイブ処理
8. スキル情報の管理
9. 給与情報の管理（希望給与・提示給与）

**関連システム・外部連携**：候補者管理（Candidate）、求人管理（JobPosition）、部門管理（Department）、ステージ管理（Stage）と連携します。

**権限による制御**：採用担当者以上の権限を持つユーザーが応募者情報の管理が可能です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-REC-001 | ApplicantResource | 主画面 | 応募者のCRUD操作 |
| SCR-REC-002 | JobPositionResource | 参照画面 | 求人情報の参照 |
| SCR-EMP-002 | DepartmentResource | 参照画面 | 部門情報の参照 |

## 機能種別

CRUD操作 / 業務プロセス管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| candidate_id | integer | Yes | 候補者ID | 存在する候補者IDを参照 |
| job_id | integer | No | 求人ID | 存在する求人IDを参照 |
| stage_id | integer | No | 選考ステージID | 存在するステージIDを参照 |
| recruiter_id | integer | No | リクルーターID | 存在するユーザーIDを参照 |
| department_id | integer | No | 部門ID | 存在する部門IDを参照 |
| priority | integer | No | 評価（0-3） | 0=未評価, 1=Good, 2=Very Good, 3=Excellent |
| salary_expected | float | No | 希望給与 | 0以上 |
| salary_expected_extra | float | No | 希望給与（追加） | 0以上 |
| salary_proposed | float | No | 提示給与 | 0以上 |
| salary_proposed_extra | float | No | 提示給与（追加） | 0以上 |
| applicant_notes | text | No | メモ | リッチテキスト |
| source_id | integer | No | 応募経路ID | 存在するソースIDを参照 |
| medium_id | integer | No | メディアID | 存在するメディアIDを参照 |

### 入力データソース

画面フォーム入力（Filament Form）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 応募者ID |
| candidate | object | 候補者情報 |
| job | object | 求人情報 |
| stage | object | 選考ステージ情報 |
| recruiter | object | リクルーター情報 |
| interviewer | array | 面接官情報（複数） |
| department | object | 部門情報 |
| priority | integer | 評価レベル |
| application_status | enum | 応募ステータス（ONGOING/HIRED/REFUSED/ARCHIVED） |
| salary_expected | float | 希望給与 |
| salary_proposed | float | 提示給与 |
| categories | array | タグ（カテゴリ） |
| source | object | 応募経路 |
| medium | object | メディア |
| create_date | date | 応募日 |
| date_closed | date | 採用決定日 |
| refuseReason | object | 不採用理由 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

画面表示（Filament Table/Infolist）、データベーステーブル（recruitments_applicants）

## 処理フロー

### 処理シーケンス

```
1. ユーザー認証確認
   └─ 未認証の場合はログイン画面へリダイレクト
2. 権限チェック
   └─ 応募者管理権限の有無を確認
3. 一覧表示処理
   └─ ステージ別グルーピングでデータ取得
   └─ BLOCKEDステータスは除外
4. CRUD操作
   └─ 作成：候補者選択 → 求人選択 → ステージ自動設定 → 保存
   └─ ステージ更新：ProgressStepperでステージ変更 → 採用ステージの場合は採用処理
   └─ 評価更新：星評価の更新
   └─ 削除：論理削除
5. 採用処理
   └─ ステージが採用ステージの場合 → date_closed設定 → 従業員作成可能
6. 不採用処理
   └─ 不採用理由選択 → refuse_reason_id設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証済み?}
    B -->|No| C[ログイン画面へ]
    B -->|Yes| D{権限確認}
    D -->|権限なし| E[403エラー]
    D -->|権限あり| F[一覧表示]
    F --> G{操作選択}
    G -->|作成| H[入力フォーム表示]
    G -->|編集| I[編集フォーム表示]
    G -->|ステージ変更| J[ProgressStepper更新]
    G -->|評価変更| K[星評価更新]
    G -->|削除| L[削除確認]
    H --> M{バリデーション}
    I --> M
    J --> N{採用ステージ?}
    N -->|Yes| O[採用処理]
    N -->|No| P[ステージ更新]
    M -->|OK| Q[DB保存]
    M -->|NG| R[エラー表示]
    Q --> S[成功通知]
    O --> S
    P --> S
    K --> S
    L --> T[論理削除]
    T --> S
    S --> F
    R --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-079-01 | 論理削除 | 削除時は論理削除（SoftDeletes） | 削除操作時 |
| BR-079-02 | デフォルトステージ | 求人選択時、デフォルトステージを自動設定 | 新規作成時 |
| BR-079-03 | 採用処理 | 採用ステージ移動時、date_closedを設定 | ステージ変更時 |
| BR-079-04 | 再オープン | 採用済みから他ステージに移動時、date_closedをクリア | ステージ変更時 |
| BR-079-05 | 不採用処理 | 不採用理由設定時、refuse_reason_idを記録 | 不採用操作時 |
| BR-079-06 | 評価連動 | 応募者評価は候補者評価にも連動 | 評価更新時 |
| BR-079-07 | BLOCKEDフィルタ | BLOCKEDステータスは一覧から除外 | 一覧表示時 |
| BR-079-08 | 面接官継承 | 求人変更時、求人の面接官を応募者にコピー | 求人変更時 |
| BR-079-09 | リクルーター継承 | 求人変更時、求人のリクルーターを応募者にコピー | 求人変更時 |
| BR-079-10 | 部門継承 | 求人変更時、求人の部門を応募者にコピー | 求人変更時 |

### 計算ロジック

- application_status: refuse_reason_id設定時はREFUSED、is_active=false時はARCHIVED、date_closed設定時はHIRED、それ以外はONGOING

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | recruitments_applicants | SELECT | 応募者一覧の取得（BLOCKED除外） |
| 詳細取得 | recruitments_applicants | SELECT | 単一応募者の取得 |
| 作成 | recruitments_applicants | INSERT | 新規応募者の登録 |
| 更新 | recruitments_applicants | UPDATE | 応募者情報の更新 |
| ステージ更新 | recruitments_applicants | UPDATE | stage_id, last_stage_id, date_last_stage_updatedの更新 |
| 採用処理 | recruitments_applicants | UPDATE | date_closed, stateの更新 |
| 削除 | recruitments_applicants | UPDATE | 論理削除（deleted_at更新） |

### テーブル別操作詳細

#### recruitments_applicants

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | state | != 'BLOCKED' | フィルタ条件 |
| INSERT | candidate_id | ユーザー選択値 | 必須 |
| INSERT | job_id | ユーザー選択値 | 任意 |
| INSERT | stage_id | デフォルトステージまたは選択値 | |
| INSERT | recruiter_id | ユーザー選択値 | 任意 |
| UPDATE | stage_id | 新ステージID | ステージ変更時 |
| UPDATE | last_stage_id | 変更前stage_id | ステージ変更時 |
| UPDATE | date_last_stage_updated | 現在日時 | ステージ変更時 |
| UPDATE | date_closed | 現在日時 | 採用時 |
| UPDATE | refuse_reason_id | 不採用理由ID | 不採用時 |
| UPDATE | priority | 0-3 | 評価更新時 |

#### recruitments_applicant_interviewers（中間テーブル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | applicant_id | 応募者ID | |
| INSERT | interviewer_id | ユーザーID | 面接官 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-079-01 | バリデーションエラー | 候補者未選択 | エラーメッセージ表示 |
| E-079-02 | 認証エラー | 未ログイン状態 | ログイン画面へリダイレクト |
| E-079-03 | 権限エラー | 操作権限なし | 403エラーページ表示 |
| E-079-04 | 存在エラー | 対象レコード不存在 | 404エラーページ表示 |

### リトライ仕様

データベース接続エラー時は自動リトライ（Laravel標準機能）

## トランザクション仕様

ステージ変更時のデータ整合性を保つため、DB::transaction()を使用

## パフォーマンス要件

- 一覧取得：2秒以内
- 単一操作（CRUD）：1秒以内
- ステージ更新：500ms以内

## セキュリティ考慮事項

- 認証必須（Filament認証）
- CSRF対策（Laravel標準）
- XSS対策（Blade自動エスケープ）
- 権限制御（Filament Shield）
- 個人情報保護（候補者情報のアクセス制限）

## 備考

- Filament v3を使用したリソース管理
- SoftDeletesトレイトによる論理削除対応
- HasChatter, HasLogActivityトレイトによるコミュニケーション・活動ログ対応
- ProgressStepperカスタムコンポーネントによる選考フロー可視化
- 星評価システムによる候補者評価
- ApplicationStatus Enumによる応募ステータス管理
- RecruitmentState Enumによる採用プロセス状態管理
- SkillsRelationManagerによる応募者スキル管理
- Candidateモデルとの連携による候補者情報の一元管理
