# 機能設計書: アナリティクス

## 1. 機能概要

| 項目 | 内容 |
|------|------|
| 機能ID | F008 |
| 機能名 | アナリティクス |
| 機能概要 | ビジネスデータの分析・集計レコードを管理し、分析用データの蓄積と参照を行う |
| 関連画面 | 各モジュールの分析ダッシュボード |
| 関連API | なし |
| 関連バッチ | なし |

## 2. 機能詳細

### 2.1 機能説明

アナリティクス機能は、ビジネスプロセスから発生する数値データ（金額、数量等）を記録し、分析用のデータ基盤を提供する。各モジュール（販売、購買、在庫等）からの集計データを一元管理する。

#### 主な機能
1. **レコード登録**: 分析データレコードの作成
2. **レコード参照**: 登録済みレコードの一覧・詳細表示
3. **パートナー連携**: 取引先との紐付け
4. **ユーザー連携**: 担当者・作成者との紐付け
5. **会社連携**: マルチカンパニー対応のデータ分離

### 2.2 処理フロー

#### レコード作成フロー
```
[開始]
   |
   v
[ビジネスイベント発生（販売、購買等）]
   |
   v
[アナリティクスレコード作成呼び出し]
   |
   v
[レコードデータ設定]
   | - type（レコードタイプ）
   | - name（レコード名）
   | - date（日付）
   | - amount（金額）
   | - unit_amount（単位金額）
   | - partner_id（取引先）
   | - company_id（会社）
   | - user_id（担当者）
   | - creator_id（作成者）
   |
   v
[analytic_recordsテーブルにレコード作成]
   |
   v
[終了]
```

### 2.3 入力仕様

| 入力項目 | 型 | 必須 | バリデーション | 説明 |
|----------|-----|------|---------------|------|
| type | string | NO | - | レコードタイプ |
| name | string | NO | max:255 | レコード名 |
| date | date | NO | date | 日付 |
| amount | decimal | NO | numeric | 金額 |
| unit_amount | decimal | NO | numeric | 単位金額 |
| partner_id | integer | NO | exists:partners,id | 取引先ID |
| company_id | integer | NO | exists:companies,id | 会社ID |
| user_id | integer | NO | exists:users,id | 担当者ID |
| creator_id | integer | NO | exists:users,id | 作成者ID |

### 2.4 出力仕様

| 出力項目 | 型 | 説明 |
|----------|-----|------|
| id | integer | レコードID |
| type | string | レコードタイプ |
| name | string | レコード名 |
| date | date | 日付 |
| amount | decimal | 金額 |
| unit_amount | decimal | 単位金額 |
| partner | object | 取引先情報 |
| company | object | 会社情報 |
| user | object | 担当者情報 |
| creator | object | 作成者情報 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

## 3. ビジネスルール

| No | ルール | 説明 |
|----|--------|------|
| BR-001 | マルチカンパニー対応 | レコードは会社単位で分離管理 |
| BR-002 | パートナー連携 | 取引先情報との紐付けにより集計可能 |
| BR-003 | ユーザー追跡 | 担当者と作成者を分離して記録 |
| BR-004 | 日付基準集計 | dateカラムを基準に期間集計が可能 |

## 4. データ設計

### 4.1 使用テーブル

| テーブル名 | 用途 | 操作 |
|------------|------|------|
| analytic_records | 分析レコード管理 | SELECT, INSERT, UPDATE, DELETE |
| partners | 取引先参照 | SELECT |
| companies | 会社参照 | SELECT |
| users | ユーザー参照 | SELECT |

### 4.2 テーブル定義（analytic_records）

| カラム名 | データ型 | NULL許可 | デフォルト | 説明 |
|----------|----------|----------|------------|------|
| id | bigint | NO | auto | 主キー |
| type | varchar(50) | YES | NULL | レコードタイプ |
| name | varchar(255) | YES | NULL | レコード名 |
| date | date | YES | NULL | 日付 |
| amount | decimal(15,2) | YES | NULL | 金額 |
| unit_amount | decimal(15,2) | YES | NULL | 単位金額 |
| partner_id | bigint | YES | NULL | 取引先ID（FK） |
| company_id | bigint | YES | NULL | 会社ID（FK） |
| user_id | bigint | YES | NULL | 担当者ID（FK） |
| creator_id | bigint | YES | NULL | 作成者ID（FK） |
| created_at | timestamp | YES | - | 作成日時 |
| updated_at | timestamp | YES | - | 更新日時 |

## 5. 関連コンポーネント

### 5.1 主要クラス

| クラス名 | パス | 役割 |
|----------|------|------|
| Record | plugins/webkul/analytics/src/Models/Record.php | 分析レコードモデル |

### 5.2 依存モジュール

| モジュール名 | 依存関係 |
|--------------|----------|
| webkul/analytics | 必須（アナリティクス基盤） |
| webkul/partner | 必須（パートナー連携） |
| webkul/support | 必須（会社管理） |
| webkul/security | 必須（ユーザー管理） |

## 6. セキュリティ

### 6.1 アクセス制御

| 権限 | 説明 |
|------|------|
| view_analytic | 分析レコードの閲覧 |
| view_any_analytic | 全分析レコードの閲覧 |
| create_analytic | 分析レコード作成 |
| update_analytic | 分析レコード更新 |
| delete_analytic | 分析レコード削除 |

### 6.2 セキュリティ考慮事項

- 会社単位でのデータアクセス制御
- 金額情報の閲覧権限管理

## 7. 非機能要件

### 7.1 パフォーマンス

| 項目 | 要件 |
|------|------|
| レコード作成速度 | 100ms以内 |
| 集計クエリ応答時間 | 3秒以内（10万件） |
| インデックス | date, company_id, partner_id に設定 |

### 7.2 可用性

- 大量データ対応のテーブル設計
- 集計処理の最適化

## 8. 例外処理

| エラーコード | エラー内容 | 対応 |
|--------------|------------|------|
| ANAL-001 | レコード作成失敗 | エラーログ出力 |
| ANAL-002 | 参照先不在 | NULL許容で継続処理 |

## 9. テスト観点

| No | テスト項目 | 確認内容 |
|----|------------|----------|
| T-001 | レコード作成 | 全項目が正しく保存されること |
| T-002 | パートナー連携 | 取引先情報が正しく取得できること |
| T-003 | 会社連携 | 会社情報が正しく取得できること |
| T-004 | ユーザー連携 | 担当者・作成者情報が取得できること |
| T-005 | 日付集計 | 期間指定で正しく集計できること |

## 10. 改訂履歴

| 版数 | 日付 | 変更者 | 変更内容 |
|------|------|--------|----------|
| 1.0 | 2025-12-26 | 自動生成 | 初版作成 |
