# 機能設計書 F081-候補者管理

## 概要

本ドキュメントは、AureusERP採用管理モジュールにおける候補者管理機能の設計を定義するものです。候補者プールの一元管理、スキル評価、将来の採用活動に向けた人材データベースの構築を実現します。

### 本機能の処理概要

**業務上の目的・背景**：採用活動において、応募者として正式にエントリーする前の潜在的な候補者や、過去の応募者を継続的に管理する必要があります。本機能は、将来の採用ニーズに備えた人材プール（タレントプール）を構築し、採用リードタイムの短縮と優秀な人材の確保を支援します。

**機能の利用シーン**：
- リクルーターが候補者情報を登録・更新する場面
- LinkedInや求人サイトから発見した候補者を登録する場面
- 過去の応募者を候補者プールに追加する場面
- 将来のポジションに適した候補者を検索・フィルタリングする場面
- 候補者のスキルや評価を管理する場面

**主要な処理内容**：
1. 候補者の基本情報（氏名、連絡先、学歴等）の登録・編集・削除
2. 候補者へのカテゴリ（タグ）付与による分類
3. 候補者のスキル情報の管理
4. 評価（優先度）の設定と星評価表示
5. 入社可能日の管理
6. マネージャーの割り当て
7. パートナー情報との自動連携

**関連システム・外部連携**：
- パートナーモジュール：候補者情報からパートナー（連絡先）を自動作成・更新
- 従業員モジュール：採用決定時に候補者から従業員レコードを作成
- Chatter：コミュニケーション履歴・活動ログの記録

**権限による制御**：CandidatePolicyによる権限管理が適用され、ユーザーのロールに基づいて閲覧・作成・編集・削除の可否が制御されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-REC-002 | CandidateResource | 主画面 | 候補者の一覧表示・作成・編集・表示・削除 |
| SCR-REC-002 | ManageSkill | 関連画面 | 候補者のスキル管理 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 候補者氏名 | 最大255文字 |
| email_from | string | No | メールアドレス | メール形式 |
| phone | string | No | 電話番号 | 電話番号形式 |
| linkedin_profile | string | No | LinkedInプロフィールURL | URL形式、最大255文字 |
| degree_id | integer | No | 学位ID | 存在する学位ID |
| manager_id | integer | No | マネージャーID | 存在するユーザーID |
| availability_date | date | No | 入社可能日 | 日付形式 |
| categories | array | No | カテゴリID配列 | 存在するカテゴリID |
| is_active | boolean | No | 有効フラグ | デフォルト: true |
| creator_id | integer | Yes | 作成者ID | ログインユーザーID（自動設定） |

### 入力データソース

- 画面フォーム入力
- LinkedInなどの外部ソースからの手動入力
- 応募者からの自動変換（将来機能）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 候補者ID |
| name | string | 候補者氏名 |
| email_from | string | メールアドレス |
| phone | string | 電話番号 |
| linkedin_profile | string | LinkedInプロフィールURL |
| degree.name | string | 学位名 |
| manager.name | string | マネージャー名 |
| availability_date | date | 入社可能日 |
| priority | integer | 評価（0-3） |
| categories | array | 関連カテゴリ一覧 |
| is_active | boolean | 有効フラグ |
| partner.name | string | 関連パートナー名 |
| company.name | string | 会社名 |

### 出力先

- 画面表示（一覧・詳細・編集フォーム）
- データベーステーブル（recruitments_candidates）

## 処理フロー

### 処理シーケンス

```
1. 候補者一覧表示
   └─ フィルター・検索条件を適用してデータ取得
2. 候補者作成
   └─ フォーム入力 → バリデーション → DB保存 → パートナー自動作成
3. 候補者編集
   └─ 既存データ取得 → フォーム表示 → 更新 → パートナー更新
4. 候補者削除
   └─ ソフトデリート実行
5. スキル管理
   └─ SkillsRelationManagerによる関連スキル管理
```

### フローチャート

```mermaid
flowchart TD
    A[候補者登録開始] --> B[基本情報入力]
    B --> C{バリデーション}
    C -->|成功| D[候補者レコード保存]
    C -->|失敗| B
    D --> E{パートナー存在?}
    E -->|No| F[パートナー自動作成]
    E -->|Yes| G[パートナー情報更新]
    F --> H[完了]
    G --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-081-01 | パートナー自動作成 | 候補者作成時にパートナーレコードを自動作成 | partner_idが未設定の場合 |
| BR-081-02 | パートナー自動更新 | 候補者更新時にパートナー情報を同期更新 | partner_idが設定済みの場合 |
| BR-081-03 | 評価スコア範囲 | 評価（priority）は0-3の範囲 | 常時 |
| BR-081-04 | 論理削除 | 削除時は物理削除せずソフトデリート | 削除操作時 |

### 計算ロジック

- 評価表示：priorityの値に応じて星アイコンを表示（3段階評価）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 候補者作成 | recruitments_candidates | INSERT | 候補者レコード作成 |
| 候補者作成 | partners_partners | INSERT | 関連パートナー自動作成 |
| 候補者更新 | recruitments_candidates | UPDATE | 候補者情報更新 |
| 候補者更新 | partners_partners | UPDATE | パートナー情報同期更新 |
| 候補者削除 | recruitments_candidates | UPDATE | ソフトデリート（deleted_at設定） |
| カテゴリ関連 | recruitments_candidate_applicant_categories | INSERT/DELETE | カテゴリ関連の管理 |

### テーブル別操作詳細

#### recruitments_candidates

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | 必須 |
| INSERT/UPDATE | email_from | フォーム入力値 | |
| INSERT/UPDATE | phone | フォーム入力値 | |
| INSERT/UPDATE | linkedin_profile | フォーム入力値 | |
| INSERT/UPDATE | degree_id | 選択された学位ID | |
| INSERT/UPDATE | manager_id | 選択されたマネージャーID | |
| INSERT/UPDATE | availability_date | フォーム入力値 | |
| INSERT/UPDATE | is_active | フォーム入力値 | デフォルトtrue |
| INSERT | creator_id | 認証ユーザーID | 自動設定 |
| INSERT | partner_id | 自動作成パートナーID | 自動設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E081-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E081-02 | 参照エラー | 存在しない学位ID/マネージャーID | エラーメッセージ表示 |
| E081-03 | 削除エラー | 関連レコード存在時 | 警告メッセージ表示 |

### リトライ仕様

特になし（同期処理）

## トランザクション仕様

候補者の作成・更新時は、候補者レコードとパートナーレコードの操作を同一トランザクション内で実行し、整合性を保証します。

## パフォーマンス要件

- 一覧表示：1秒以内のレスポンス
- 検索・フィルタリング：2秒以内のレスポンス
- グローバル検索対象：name, email_from, phone, company.name, degree.name

## セキュリティ考慮事項

- CandidatePolicyによるアクセス制御
- 認証ユーザーのみアクセス可能
- 作成者情報（creator_id）の自動記録
- 論理削除によるデータ保全

## 備考

- HasChatter, HasLogActivityトレイトを使用してコミュニケーション履歴と活動ログを管理
- カードレイアウト（Grid）による視覚的な一覧表示
- 候補者から従業員への変換機能（createEmployeeメソッド）を備える
