# 機能設計書 F082-採用ステージ管理

## 概要

本ドキュメントは、AureusERP採用管理モジュールにおける採用ステージ管理機能の設計を定義するものです。採用プロセスの各段階（ステージ）を定義・管理し、応募者の選考フローを可視化・制御します。

### 本機能の処理概要

**業務上の目的・背景**：採用活動において、応募者が書類選考から内定までどの段階にいるかを明確に管理する必要があります。本機能は、採用パイプラインを構成するステージを定義し、各ステージの状態ラベル（進行中・ブロック・完了）、要件、表示順序を管理することで、採用プロセスの標準化と効率化を実現します。

**機能の利用シーン**：
- 人事担当者が採用プロセスのステージを定義する場面
- 各ステージに紐づく求人職位を設定する場面
- ステージの表示順序を並び替える場面
- 採用決定ステージ（Hired Stage）を指定する場面
- ステージのフォールド（折りたたみ）設定を行う場面

**主要な処理内容**：
1. ステージの作成・編集・削除
2. ステージ名と要件の設定
3. 状態ラベル（Normal/Blocked/Done）の定義
4. 関連する求人職位の紐付け
5. ドラッグ＆ドロップによる並び替え
6. デフォルトステージ、採用決定ステージ、フォールド設定

**関連システム・外部連携**：
- 求人職位モジュール：ステージと求人職位の多対多関連
- 応募者モジュール：応募者の進捗管理でステージを参照

**権限による制御**：StageResourceへのアクセスは認証ユーザーに限定され、Configurationsクラスター配下で管理者向けに提供されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-REC-005 | StageResource | 主画面 | ステージの一覧表示・作成・編集・削除 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | ステージ名 | - |
| requirements | string | No | 要件・説明 | 最大255文字、リッチテキスト |
| legend_normal | string | Yes | 通常状態ラベル（グレー） | デフォルト: "In Progress" |
| legend_blocked | string | Yes | ブロック状態ラベル（赤） | デフォルト: "Blocked" |
| legend_done | string | Yes | 完了状態ラベル（緑） | デフォルト: "Ready for Next Stage" |
| jobs | array | No | 関連求人職位ID配列 | 存在する職位ID |
| fold | boolean | No | フォールド（折りたたみ）設定 | デフォルト: false |
| hired_stage | boolean | No | 採用決定ステージフラグ | デフォルト: false |
| is_default | boolean | No | デフォルトステージフラグ | デフォルト: false |
| creator_id | integer | Yes | 作成者ID | ログインユーザーID（自動設定） |

### 入力データソース

- 画面フォーム入力
- 初期シーダーデータ（StageSeeder）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | ステージID |
| name | string | ステージ名 |
| requirements | string | 要件・説明（HTML） |
| legend_normal | string | 通常状態ラベル |
| legend_blocked | string | ブロック状態ラベル |
| legend_done | string | 完了状態ラベル |
| jobs | array | 関連求人職位一覧 |
| fold | boolean | フォールド設定 |
| hired_stage | boolean | 採用決定ステージ |
| is_default | boolean | デフォルトステージ |
| sort | integer | 並び順 |
| createdBy.name | string | 作成者名 |

### 出力先

- 画面表示（一覧・詳細・編集フォーム）
- データベーステーブル（recruitments_stages）

## 処理フロー

### 処理シーケンス

```
1. ステージ一覧表示
   └─ ソート順に基づいてデータ取得
2. ステージ作成
   └─ フォーム入力 → バリデーション → DB保存 → ソート自動付与
3. ステージ編集
   └─ 既存データ取得 → フォーム表示 → 更新
4. ステージ並び替え
   └─ ドラッグ＆ドロップ → sort値更新
5. ステージ削除
   └─ 関連チェック → 削除実行（または警告）
```

### フローチャート

```mermaid
flowchart TD
    A[ステージ管理開始] --> B[一覧表示]
    B --> C{操作選択}
    C -->|作成| D[新規作成フォーム]
    C -->|編集| E[編集フォーム]
    C -->|削除| F{関連データ存在?}
    C -->|並替| G[ドラッグ＆ドロップ]
    D --> H[保存]
    E --> H
    F -->|No| I[削除実行]
    F -->|Yes| J[エラー通知]
    G --> K[sort更新]
    H --> B
    I --> B
    K --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-082-01 | ソート自動付与 | 作成時に自動でsort値を付与 | SortableTrait使用 |
| BR-082-02 | 関連削除制限 | 応募者に使用中のステージは削除不可 | 削除操作時 |
| BR-082-03 | デフォルトステージ | is_default=trueのステージが初期ステージ | 応募者作成時 |
| BR-082-04 | 採用決定ステージ | hired_stage=trueで採用完了とみなす | 応募者ステータス変更時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ステージ作成 | recruitments_stages | INSERT | ステージレコード作成 |
| ステージ更新 | recruitments_stages | UPDATE | ステージ情報更新 |
| ステージ削除 | recruitments_stages | DELETE | ステージレコード削除 |
| 職位関連付け | recruitments_stages_jobs | INSERT/DELETE | 求人職位との関連管理 |
| 並び替え | recruitments_stages | UPDATE | sort値の更新 |

### テーブル別操作詳細

#### recruitments_stages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | 必須 |
| INSERT/UPDATE | requirements | フォーム入力値 | リッチテキスト |
| INSERT/UPDATE | legend_normal | フォーム入力値 | デフォルト: "In Progress" |
| INSERT/UPDATE | legend_blocked | フォーム入力値 | デフォルト: "Blocked" |
| INSERT/UPDATE | legend_done | フォーム入力値 | デフォルト: "Ready for Next Stage" |
| INSERT/UPDATE | fold | フォーム入力値 | デフォルト: false |
| INSERT/UPDATE | hired_stage | フォーム入力値 | デフォルト: false |
| INSERT/UPDATE | is_default | フォーム入力値 | デフォルト: false |
| INSERT | creator_id | 認証ユーザーID | 自動設定 |
| INSERT | sort | SortableTraitによる自動計算 | 自動設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E082-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E082-02 | 削除制限エラー | 関連データ存在時の削除 | 警告通知表示（QueryException捕捉） |

### リトライ仕様

特になし（同期処理）

## トランザクション仕様

ステージと求人職位の関連付けは同一トランザクション内で実行し、整合性を保証します。

## パフォーマンス要件

- 一覧表示：1秒以内のレスポンス
- 並び替え操作：即時反映

## セキュリティ考慮事項

- 認証ユーザーのみアクセス可能
- Configurationsクラスター配下で管理者機能として提供
- 作成者情報（creator_id）の自動記録

## 備考

- Spatie EloquentSortableパッケージを使用したドラッグ＆ドロップ並び替え
- 列の表示/非表示切り替え機能（toggleable）
- グルーピング機能（ステージ名、フォールド状態、ラベル、作成者、日付）
