# 機能設計書 F083-学歴管理

## 概要

本ドキュメントは、AureusERP採用管理モジュールにおける学歴管理機能の設計を定義するものです。候補者や応募者の学歴（学位・資格）マスタを管理し、採用プロセスにおける人材評価の基準として活用します。

### 本機能の処理概要

**業務上の目的・背景**：採用活動において、候補者の学歴情報は重要な評価要素の一つです。本機能は、学位・資格のマスタデータを一元管理し、候補者登録時の選択肢として提供することで、データの標準化と入力効率の向上を実現します。

**機能の利用シーン**：
- 人事担当者が学歴マスタに新しい学位を追加する場面
- 既存の学歴項目の名称を変更する場面
- 使用されていない学歴項目を削除する場面
- 候補者登録時に学歴を選択する際の参照元として

**主要な処理内容**：
1. 学歴（学位）の作成・編集・削除
2. 学歴名の管理
3. ドラッグ＆ドロップによる表示順序の並び替え
4. 候補者との関連（参照）

**関連システム・外部連携**：
- 候補者モジュール：候補者の学歴フィールドで参照

**権限による制御**：DegreePolicyによる権限管理が適用され、ユーザーのロールに基づいてアクセスが制御されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-REC-006 | DegreeResource | 主画面 | 学歴の一覧表示・作成・編集・削除 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 学歴名（学位名） | 最大255文字 |
| creator_id | integer | Yes | 作成者ID | ログインユーザーID（自動設定） |

### 入力データソース

- 画面フォーム入力
- 初期シーダーデータ（DegreeSeeder）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 学歴ID |
| name | string | 学歴名 |
| sort | integer | 並び順 |
| createdBy.name | string | 作成者名 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（一覧・編集フォーム）
- データベーステーブル（recruitments_degrees）

## 処理フロー

### 処理シーケンス

```
1. 学歴一覧表示
   └─ ソート順に基づいてデータ取得
2. 学歴作成
   └─ フォーム入力 → バリデーション → DB保存 → ソート自動付与
3. 学歴編集
   └─ インライン編集またはモーダル → 更新
4. 学歴削除
   └─ 確認ダイアログ → 削除実行
5. 並び替え
   └─ ドラッグ＆ドロップ → sort値更新
```

### フローチャート

```mermaid
flowchart TD
    A[学歴管理開始] --> B[一覧表示]
    B --> C{操作選択}
    C -->|作成| D[モーダルフォーム]
    C -->|編集| E[インライン/モーダル編集]
    C -->|削除| F[削除確認]
    C -->|並替| G[ドラッグ＆ドロップ]
    D --> H[保存]
    E --> H
    F --> I[削除実行]
    G --> J[sort更新]
    H --> B
    I --> B
    J --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-083-01 | ソート自動付与 | 作成時に自動でsort値を付与 | SortableTrait使用 |
| BR-083-02 | 一意性 | 学歴名は重複不可（推奨） | 作成・編集時 |
| BR-083-03 | 参照整合性 | 候補者に使用中の学歴は削除時に警告 | 削除操作時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 学歴作成 | recruitments_degrees | INSERT | 学歴レコード作成 |
| 学歴更新 | recruitments_degrees | UPDATE | 学歴情報更新 |
| 学歴削除 | recruitments_degrees | DELETE | 学歴レコード削除 |
| 並び替え | recruitments_degrees | UPDATE | sort値の更新 |

### テーブル別操作詳細

#### recruitments_degrees

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | 必須 |
| INSERT | creator_id | 認証ユーザーID | 自動設定 |
| INSERT | sort | SortableTraitによる自動計算 | 自動設定、デフォルト0 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E083-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E083-02 | 参照エラー | 使用中データの削除 | 候補者のdegree_id=nullに設定（nullOnDelete） |

### リトライ仕様

特になし（同期処理）

## トランザクション仕様

単純なCRUD操作のため、標準的なトランザクション処理で対応します。

## パフォーマンス要件

- 一覧表示：1秒以内のレスポンス
- マスタデータのため、通常は少量のレコード

## セキュリティ考慮事項

- DegreePolicyによるアクセス制御
- 認証ユーザーのみアクセス可能
- Configurationsクラスター配下で管理者機能として提供
- 作成者情報（creator_id）の自動記録

## 備考

- Spatie EloquentSortableパッケージを使用したドラッグ＆ドロップ並び替え（降順）
- SimpleResourceとしてシンプルな一覧画面のみで構成
- モーダル形式での作成・編集・表示
- 列の表示/非表示切り替え機能
