# 機能設計書 F084-不採用理由管理

## 概要

本ドキュメントは、AureusERP採用管理モジュールにおける不採用理由管理機能の設計を定義するものです。応募者を不採用とする際の理由マスタを管理し、不採用通知メールのテンプレートと連携します。

### 本機能の処理概要

**業務上の目的・背景**：採用活動において、応募者を不採用とする場合、その理由を記録し適切な通知を行う必要があります。本機能は、不採用理由を標準化して管理し、対応するメールテンプレートと紐付けることで、不採用プロセスの効率化と一貫性のある候補者対応を実現します。また、不採用理由のデータを蓄積することで、採用プロセスの改善にも活用できます。

**機能の利用シーン**：
- 人事担当者が不採用理由マスタを設定する場面
- 応募者を不採用とする際に理由を選択する場面
- 不採用通知メールを送信する際のテンプレート選択の場面
- 不採用理由の傾向を分析する場面

**主要な処理内容**：
1. 不採用理由の作成・編集・削除
2. 不採用理由名の管理
3. 対応するメールテンプレートの選択（企業都合/応募者辞退）
4. ドラッグ＆ドロップによる表示順序の並び替え
5. 有効/無効ステータスの管理

**関連システム・外部連携**：
- 応募者モジュール：応募者の不採用処理で参照
- メール送信機能：不採用通知メールのテンプレート選択

**権限による制御**：RefuseReasonPolicyによる権限管理が適用されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-REC-007 | RefuseReasonResource | 主画面 | 不採用理由の一覧表示・作成・編集・削除 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 不採用理由名 | 最大255文字 |
| template | string | Yes | メールテンプレート種別 | applicant-refuse / applicant-not-interested |
| is_active | boolean | No | 有効フラグ | デフォルト: true |
| creator_id | integer | Yes | 作成者ID | ログインユーザーID（自動設定） |

### 入力データソース

- 画面フォーム入力
- 初期シーダーデータ（RefuseReasonSeeder）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 不採用理由ID |
| name | string | 不採用理由名 |
| template | string | メールテンプレート種別 |
| is_active | boolean | 有効フラグ |
| sort | integer | 並び順 |
| createdBy.name | string | 作成者名 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（一覧・編集フォーム）
- データベーステーブル（recruitments_refuse_reasons）

## 処理フロー

### 処理シーケンス

```
1. 不採用理由一覧表示
   └─ ソート順に基づいてデータ取得
2. 不採用理由作成
   └─ フォーム入力 → テンプレート選択 → DB保存
3. 不採用理由編集
   └─ 既存データ取得 → 編集 → 更新
4. 不採用理由削除
   └─ 確認ダイアログ → 削除実行
5. 並び替え
   └─ ドラッグ＆ドロップ → sort値更新
```

### フローチャート

```mermaid
flowchart TD
    A[不採用理由管理開始] --> B[一覧表示]
    B --> C{操作選択}
    C -->|作成| D[モーダルフォーム]
    C -->|編集| E[編集モーダル]
    C -->|削除| F[削除確認]
    C -->|並替| G[ドラッグ＆ドロップ]
    D --> H{テンプレート選択}
    H -->|企業都合| I[applicant-refuse]
    H -->|応募者辞退| J[applicant-not-interested]
    I --> K[保存]
    J --> K
    E --> K
    F --> L[削除実行]
    G --> M[sort更新]
    K --> B
    L --> B
    M --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-084-01 | ソート自動付与 | 作成時に自動でsort値を付与 | SortableTrait使用 |
| BR-084-02 | テンプレート必須 | 不採用理由には必ずメールテンプレートを紐付け | 作成・編集時 |
| BR-084-03 | 企業都合テンプレート | applicant-refuseは企業側判断の不採用に使用 | テンプレート選択時 |
| BR-084-04 | 応募者辞退テンプレート | applicant-not-interestedは応募者辞退に使用 | テンプレート選択時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 不採用理由作成 | recruitments_refuse_reasons | INSERT | 不採用理由レコード作成 |
| 不採用理由更新 | recruitments_refuse_reasons | UPDATE | 不採用理由情報更新 |
| 不採用理由削除 | recruitments_refuse_reasons | DELETE | 不採用理由レコード削除 |
| 並び替え | recruitments_refuse_reasons | UPDATE | sort値の更新 |

### テーブル別操作詳細

#### recruitments_refuse_reasons

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | 必須 |
| INSERT/UPDATE | template | 選択されたテンプレート | 必須 |
| INSERT/UPDATE | is_active | フォーム入力値 | デフォルト: true |
| INSERT | creator_id | 認証ユーザーID | 自動設定 |
| INSERT | sort | SortableTraitによる自動計算 | デフォルト: 0 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E084-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E084-02 | テンプレート未選択 | テンプレート未選択 | エラーメッセージ表示 |

### リトライ仕様

特になし（同期処理）

## トランザクション仕様

単純なCRUD操作のため、標準的なトランザクション処理で対応します。

## パフォーマンス要件

- 一覧表示：1秒以内のレスポンス
- マスタデータのため、通常は少量のレコード

## セキュリティ考慮事項

- RefuseReasonPolicyによるアクセス制御
- 認証ユーザーのみアクセス可能
- Configurationsクラスター配下で管理者機能として提供
- 作成者情報（creator_id）の自動記録

## 備考

- テンプレート種別：
  - `applicant-refuse`: 企業側判断による不採用（書類選考落ち、面接不合格等）
  - `applicant-not-interested`: 応募者側からの辞退・興味なし
- 対応するメールテンプレート：
  - `mails/applicant-refuse.blade.php`
  - `mails/applicant-not-interested.blade.php`
- Spatie EloquentSortableパッケージを使用した並び替え（降順）
