# 機能設計書 F085-応募者カテゴリ管理

## 概要

本ドキュメントは、AureusERP採用管理モジュールにおける応募者カテゴリ管理機能の設計を定義するものです。応募者や候補者に付与するタグ（カテゴリ）を管理し、人材の分類・検索・フィルタリングを効率化します。

### 本機能の処理概要

**業務上の目的・背景**：採用活動において、多数の応募者・候補者を効率的に管理するために、カテゴリ（タグ）による分類が必要です。本機能は、「新卒」「中途」「エンジニア」「営業」などのカテゴリを定義・管理し、応募者・候補者にタグ付けすることで、検索・フィルタリング・レポート作成を容易にします。

**機能の利用シーン**：
- 人事担当者がカテゴリマスタに新しい分類を追加する場面
- カテゴリの色を設定して視覚的な識別を行う場面
- 応募者・候補者にカテゴリを割り当てる際の参照元として
- カテゴリでフィルタリングして対象者を絞り込む場面

**主要な処理内容**：
1. 応募者カテゴリの作成・編集・削除
2. カテゴリ名の管理
3. カテゴリ色（識別カラー）の設定
4. 応募者・候補者との関連（多対多）

**関連システム・外部連携**：
- 応募者モジュール：応募者のカテゴリ割り当て
- 候補者モジュール：候補者のカテゴリ割り当て

**権限による制御**：ApplicantCategoryPolicyによる権限管理が適用されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-REC-008 | ApplicantCategoryResource | 主画面 | カテゴリの一覧表示・作成・編集・削除 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | カテゴリ名 | 最大255文字 |
| color | string | Yes | 識別カラー | HEX形式（#RRGGBB） |
| creator_id | integer | Yes | 作成者ID | ログインユーザーID（自動設定） |

### 入力データソース

- 画面フォーム入力
- 初期シーダーデータ（ApplicantCategorySeeder）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | カテゴリID |
| name | string | カテゴリ名 |
| color | string | 識別カラー（HEX） |
| createdBy.name | string | 作成者名 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（一覧・編集フォーム）
- データベーステーブル（recruitments_applicant_categories）

## 処理フロー

### 処理シーケンス

```
1. カテゴリ一覧表示
   └─ データベースからカテゴリ一覧取得
2. カテゴリ作成
   └─ フォーム入力 → 色選択 → DB保存
3. カテゴリ編集
   └─ 既存データ取得 → 編集 → 更新
4. カテゴリ削除
   └─ 確認ダイアログ → 削除実行（関連テーブルも整理）
```

### フローチャート

```mermaid
flowchart TD
    A[カテゴリ管理開始] --> B[一覧表示]
    B --> C{操作選択}
    C -->|作成| D[モーダルフォーム]
    C -->|編集| E[編集モーダル]
    C -->|削除| F[削除確認]
    D --> G[名前入力]
    G --> H[色選択]
    H --> I[保存]
    E --> I
    F --> J[削除実行]
    I --> B
    J --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-085-01 | カラー必須 | カテゴリには識別色を必ず設定 | 作成・編集時 |
| BR-085-02 | 一意性推奨 | カテゴリ名は重複を避ける | 作成・編集時 |
| BR-085-03 | 多対多関連 | 応募者・候補者は複数カテゴリを持てる | 関連付け時 |
| BR-085-04 | バッジ表示 | 一覧画面でカテゴリは色付きバッジで表示 | 表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カテゴリ作成 | recruitments_applicant_categories | INSERT | カテゴリレコード作成 |
| カテゴリ更新 | recruitments_applicant_categories | UPDATE | カテゴリ情報更新 |
| カテゴリ削除 | recruitments_applicant_categories | DELETE | カテゴリレコード削除 |
| カテゴリ削除 | recruitments_applicant_applicant_categories | DELETE | 関連削除（応募者） |
| カテゴリ削除 | recruitments_candidate_applicant_categories | DELETE | 関連削除（候補者） |

### テーブル別操作詳細

#### recruitments_applicant_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | 必須 |
| INSERT/UPDATE | color | カラーピッカー選択値 | HEX形式、必須 |
| INSERT | creator_id | 認証ユーザーID | 自動設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E085-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E085-02 | カラー形式エラー | 不正なHEX形式 | エラーメッセージ表示 |

### リトライ仕様

特になし（同期処理）

## トランザクション仕様

単純なCRUD操作のため、標準的なトランザクション処理で対応します。

## パフォーマンス要件

- 一覧表示：1秒以内のレスポンス
- マスタデータのため、通常は少量のレコード

## セキュリティ考慮事項

- ApplicantCategoryPolicyによるアクセス制御
- 認証ユーザーのみアクセス可能
- Configurationsクラスター配下で管理者機能として提供
- 作成者情報（creator_id）の自動記録

## 備考

- ColorPickerコンポーネントによる視覚的な色選択
- ColorColumn/ColorEntryによる色の表示
- 応募者一覧・候補者一覧でバッジとして表示される際にカテゴリ色を使用
- Color::generateV3Palette()による動的カラーパレット生成
