# 機能設計書 F086-雇用形態管理（採用）

## 概要

本ドキュメントは、AureusERP採用管理モジュールにおける雇用形態管理機能の設計を定義するものです。採用プロセスで使用する雇用形態（正社員、契約社員、パートタイム等）のマスタを管理します。

### 本機能の処理概要

**業務上の目的・背景**：採用活動において、求人ポジションや応募者の雇用形態を明確に定義・管理する必要があります。本機能は、従業員モジュールの雇用形態マスタを採用モジュールで共有利用し、採用から入社までの一貫したデータ管理を実現します。

**機能の利用シーン**：
- 人事担当者が雇用形態マスタを設定する場面
- 求人作成時に雇用形態を選択する場面
- 応募者の希望雇用形態を記録する場面
- 雇用形態別の採用レポートを作成する場面

**主要な処理内容**：
1. 雇用形態の作成・編集・削除
2. 雇用形態名・コードの管理
3. 対象国の設定
4. ドラッグ＆ドロップによる表示順序の並び替え

**関連システム・外部連携**：
- 従業員モジュール：雇用形態マスタを共有（BaseEmploymentTypeを継承）
- 求人職位モジュール：求人の雇用形態として参照

**権限による制御**：EmploymentTypePolicyによる権限管理が適用されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-REC-010 | EmploymentTypeResource | 主画面 | 雇用形態の一覧表示・作成・編集・削除 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 雇用形態名 | - |
| code | string | No | 雇用形態コード | - |
| country_id | integer | No | 対象国ID | 存在する国ID |
| creator_id | integer | Yes | 作成者ID | ログインユーザーID（自動設定） |

### 入力データソース

- 画面フォーム入力
- 従業員モジュールの既存データ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 雇用形態ID |
| name | string | 雇用形態名 |
| code | string | 雇用形態コード |
| country.name | string | 対象国名 |
| sort | integer | 並び順 |
| createdBy.name | string | 作成者名 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（一覧・編集フォーム）
- データベーステーブル（employees_employment_types）

## 処理フロー

### 処理シーケンス

```
1. 雇用形態一覧表示
   └─ ソート順に基づいてデータ取得
2. 雇用形態作成
   └─ フォーム入力 → バリデーション → DB保存
3. 雇用形態編集
   └─ 既存データ取得 → 編集 → 更新
4. 雇用形態削除
   └─ 確認ダイアログ → 削除実行
5. 並び替え
   └─ ドラッグ＆ドロップ → sort値更新
```

### フローチャート

```mermaid
flowchart TD
    A[雇用形態管理開始] --> B[一覧表示]
    B --> C{操作選択}
    C -->|作成| D[モーダルフォーム]
    C -->|編集| E[編集モーダル]
    C -->|削除| F[削除確認]
    C -->|並替| G[ドラッグ＆ドロップ]
    D --> H[保存]
    E --> H
    F --> I[削除実行]
    G --> J[sort更新]
    H --> B
    I --> B
    J --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-086-01 | ソート自動付与 | 作成時に自動でsort値を付与 | SortableTrait使用 |
| BR-086-02 | 共有マスタ | 従業員モジュールと雇用形態マスタを共有 | 常時 |
| BR-086-03 | 国別設定 | 国別に異なる雇用形態を設定可能 | country_id設定時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 雇用形態作成 | employees_employment_types | INSERT | 雇用形態レコード作成 |
| 雇用形態更新 | employees_employment_types | UPDATE | 雇用形態情報更新 |
| 雇用形態削除 | employees_employment_types | DELETE | 雇用形態レコード削除 |
| 並び替え | employees_employment_types | UPDATE | sort値の更新 |

### テーブル別操作詳細

#### employees_employment_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | 必須 |
| INSERT/UPDATE | code | フォーム入力値 | |
| INSERT/UPDATE | country_id | 選択された国ID | |
| INSERT | creator_id | 認証ユーザーID | 自動設定 |
| INSERT | sort | SortableTraitによる自動計算 | 自動設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E086-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E086-02 | 参照エラー | 存在しない国ID | エラーメッセージ表示 |

### リトライ仕様

特になし（同期処理）

## トランザクション仕様

単純なCRUD操作のため、標準的なトランザクション処理で対応します。

## パフォーマンス要件

- 一覧表示：1秒以内のレスポンス
- マスタデータのため、通常は少量のレコード

## セキュリティ考慮事項

- EmploymentTypePolicyによるアクセス制御
- 認証ユーザーのみアクセス可能
- Configurationsクラスター配下で管理者機能として提供
- 作成者情報（creator_id）の自動記録

## 備考

- 従業員モジュールのEmploymentTypeResourceを継承（BaseEmploymentTypeResource）
- 採用モジュール用にクラスター設定とページをオーバーライド
- HasCustomFieldsトレイトによるカスタムフィールド拡張に対応
- Spatie EloquentSortableパッケージを使用した並び替え
