# 機能設計書 F087-スキルタイプ管理（採用）

## 概要

本ドキュメントは、AureusERP採用管理モジュールにおけるスキルタイプ管理機能の設計を定義するものです。候補者や応募者のスキル評価に使用するスキルタイプ（スキルカテゴリ）のマスタを管理します。

### 本機能の処理概要

**業務上の目的・背景**：採用活動において、候補者のスキルを体系的に評価・管理する必要があります。本機能は、従業員モジュールのスキルタイプマスタを採用モジュールで共有利用し、「プログラミング言語」「ビジネススキル」「資格」などのスキルカテゴリを定義することで、候補者のスキル評価を標準化します。

**機能の利用シーン**：
- 人事担当者がスキルタイプマスタを設定する場面
- 候補者のスキルを登録する際にスキルタイプを選択する場面
- スキルレベルを定義する場面
- スキル別の候補者検索・フィルタリングを行う場面

**主要な処理内容**：
1. スキルタイプの作成・編集・削除
2. スキルタイプ名・識別色の管理
3. スキルレベルの定義（関連テーブル）
4. 個別スキルの定義（関連テーブル）
5. 有効/無効ステータスの管理

**関連システム・外部連携**：
- 従業員モジュール：スキルタイプマスタを共有（BaseSkillTypeを継承）
- 候補者モジュール：候補者スキルの評価で参照

**権限による制御**：SkillTypePolicyによる権限管理が適用されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-REC-011 | SkillTypeResource | 主画面 | スキルタイプの一覧表示・作成・編集・削除 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | スキルタイプ名 | - |
| color | string | No | 識別カラー | - |
| is_active | boolean | No | 有効フラグ | デフォルト: true |
| creator_id | integer | Yes | 作成者ID | ログインユーザーID（自動設定） |

### 入力データソース

- 画面フォーム入力
- 従業員モジュールの既存データ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | スキルタイプID |
| name | string | スキルタイプ名 |
| color | string | 識別カラー |
| is_active | boolean | 有効フラグ |
| skillLevels | array | スキルレベル一覧 |
| skills | array | スキル一覧 |
| createdBy.name | string | 作成者名 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（一覧・詳細・編集フォーム）
- データベーステーブル（employees_skill_types）

## 処理フロー

### 処理シーケンス

```
1. スキルタイプ一覧表示
   └─ データベースからスキルタイプ一覧取得
2. スキルタイプ作成
   └─ フォーム入力 → バリデーション → DB保存
3. スキルタイプ編集
   └─ 既存データ取得 → 編集 → 更新
4. スキルタイプ削除
   └─ 論理削除（SoftDelete）実行
5. スキルレベル管理
   └─ RelationManagerによる関連レベル管理
6. スキル管理
   └─ RelationManagerによる関連スキル管理
```

### フローチャート

```mermaid
flowchart TD
    A[スキルタイプ管理開始] --> B[一覧表示]
    B --> C{操作選択}
    C -->|作成| D[作成フォーム]
    C -->|編集| E[編集画面]
    C -->|表示| F[詳細画面]
    C -->|削除| G[論理削除]
    D --> H[保存]
    E --> H
    F --> I{関連管理?}
    I -->|スキルレベル| J[レベル管理]
    I -->|スキル| K[スキル管理]
    G --> B
    H --> B
    J --> F
    K --> F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-087-01 | 論理削除 | 削除時は物理削除せずソフトデリート | SoftDeletesトレイト使用 |
| BR-087-02 | 共有マスタ | 従業員モジュールとスキルタイプマスタを共有 | 常時 |
| BR-087-03 | スキル階層 | スキルタイプ > スキル > スキルレベルの階層構造 | 関連管理時 |
| BR-087-04 | 有効/無効 | is_activeで有効なスキルタイプのみ選択可能 | スキル登録時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| スキルタイプ作成 | employees_skill_types | INSERT | スキルタイプレコード作成 |
| スキルタイプ更新 | employees_skill_types | UPDATE | スキルタイプ情報更新 |
| スキルタイプ削除 | employees_skill_types | UPDATE | ソフトデリート（deleted_at設定） |

### テーブル別操作詳細

#### employees_skill_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | 必須 |
| INSERT/UPDATE | color | フォーム入力値 | |
| INSERT/UPDATE | is_active | フォーム入力値 | デフォルト: true |
| INSERT | creator_id | 認証ユーザーID | 自動設定 |
| DELETE | deleted_at | 現在日時 | ソフトデリート |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E087-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E087-02 | 参照エラー | 削除済みスキルタイプの参照 | エラーメッセージ表示 |

### リトライ仕様

特になし（同期処理）

## トランザクション仕様

単純なCRUD操作のため、標準的なトランザクション処理で対応します。

## パフォーマンス要件

- 一覧表示：1秒以内のレスポンス
- マスタデータのため、通常は少量のレコード

## セキュリティ考慮事項

- SkillTypePolicyによるアクセス制御
- 認証ユーザーのみアクセス可能
- Configurationsクラスター配下で管理者機能として提供
- 作成者情報（creator_id）の自動記録
- 論理削除によるデータ保全

## 備考

- 従業員モジュールのSkillTypeResourceを継承（BaseSkillTypeResource）
- 採用モジュール用にクラスター設定とページをオーバーライド
- HasCustomFieldsトレイトによるカスタムフィールド拡張に対応
- SoftDeletesによる論理削除で履歴データを保全
- skillLevels関連：スキルの習熟度レベルを定義
- skills関連：スキルタイプに属する個別スキルを定義
