# 機能設計書 F088-UTMソース管理

## 概要

本ドキュメントは、AureusERP採用管理モジュールにおけるUTMソース管理機能の設計を定義するものです。応募者の流入経路（ソース）を追跡するためのUTMソースマスタを管理し、採用チャネルの効果測定に活用します。

### 本機能の処理概要

**業務上の目的・背景**：採用活動において、どの経路（求人サイト、SNS、リファラル等）から応募者が来たかを把握することは、採用マーケティングの効果測定と投資最適化に不可欠です。本機能は、UTM（Urchin Tracking Module）パラメータのソース情報を管理し、応募経路分析を可能にします。

**機能の利用シーン**：
- 人事担当者がUTMソースマスタを設定する場面
- 求人広告出稿時にソースを設定する場面
- 応募者にソース情報を紐付ける場面
- ソース別の応募者数・採用率を分析する場面

**主要な処理内容**：
1. UTMソースの作成・編集・削除
2. ソース名の管理（例：LinkedIn, Indeed, Referral等）
3. 応募者との関連（参照）

**関連システム・外部連携**：
- サポートモジュール：UTMソースマスタを共有（BaseUTMSourceを継承）
- 応募者モジュール：応募者の流入ソースとして参照

**権限による制御**：UTMSourcePolicyによる権限管理が適用されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-REC-012 | UTMSourceResource | 主画面 | UTMソースの一覧表示・作成・編集・削除 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | ソース名 | 最大255文字 |
| creator_id | integer | Yes | 作成者ID | ログインユーザーID（自動設定） |

### 入力データソース

- 画面フォーム入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | ソースID |
| name | string | ソース名 |
| createdBy.name | string | 作成者名 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（一覧・編集フォーム）
- データベーステーブル（utm_sources）

## 処理フロー

### 処理シーケンス

```
1. UTMソース一覧表示
   └─ データベースからソース一覧取得
2. UTMソース作成
   └─ フォーム入力 → バリデーション → DB保存
3. UTMソース編集
   └─ 既存データ取得 → 編集 → 更新
4. UTMソース削除
   └─ 確認ダイアログ → 削除実行
```

### フローチャート

```mermaid
flowchart TD
    A[UTMソース管理開始] --> B[一覧表示]
    B --> C{操作選択}
    C -->|作成| D[モーダルフォーム]
    C -->|編集| E[編集モーダル]
    C -->|削除| F[削除確認]
    D --> G[保存]
    E --> G
    F --> H[削除実行]
    G --> B
    H --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-088-01 | UTM標準 | UTMパラメータのソース（utm_source）に対応 | 常時 |
| BR-088-02 | 共有マスタ | サポートモジュールとUTMソースマスタを共有 | 常時 |
| BR-088-03 | 一意性推奨 | ソース名は重複を避ける | 作成・編集時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| UTMソース作成 | utm_sources | INSERT | ソースレコード作成 |
| UTMソース更新 | utm_sources | UPDATE | ソース情報更新 |
| UTMソース削除 | utm_sources | DELETE | ソースレコード削除 |

### テーブル別操作詳細

#### utm_sources

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | 必須 |
| INSERT | creator_id | 認証ユーザーID | 自動設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E088-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |

### リトライ仕様

特になし（同期処理）

## トランザクション仕様

単純なCRUD操作のため、標準的なトランザクション処理で対応します。

## パフォーマンス要件

- 一覧表示：1秒以内のレスポンス
- マスタデータのため、通常は少量のレコード

## セキュリティ考慮事項

- UTMSourcePolicyによるアクセス制御
- 認証ユーザーのみアクセス可能
- Configurationsクラスター配下で管理者機能として提供
- 作成者情報（creator_id）の自動記録

## 備考

- サポートモジュールのUTMSourceモデルを継承
- UTM（Urchin Tracking Module）はGoogleアナリティクスで使用されるURL追跡パラメータ
- utm_sourceはトラフィックの発生元を識別（例：google, facebook, linkedin, indeed）
- 採用マーケティングのROI分析に活用
- スラッグ設定：`utm-source`
