# 機能設計書: チャッター

## 1. 機能概要

| 項目 | 内容 |
|------|------|
| 機能ID | F009 |
| 機能名 | チャッター |
| 機能概要 | エンティティに対するコミュニケーション・アクティビティ管理・フォロワー機能を提供するコラボレーション基盤 |
| 関連画面 | 各リソース詳細画面のチャッターパネル |
| 関連API | なし |
| 関連バッチ | なし |

## 2. 機能詳細

### 2.1 機能説明

チャッター機能は、各エンティティ（顧客、注文、プロジェクト等）に対してメッセージ、ノート、アクティビティを追加し、関係者間のコミュニケーションを促進する機能を提供する。Odoo風のチャッターUIを実装。

#### 主な機能
1. **メッセージ投稿**: コメント、ノート、通知等のメッセージ投稿
2. **アクティビティ管理**: 予定アクティビティの登録・編集・完了処理
3. **フォロワー管理**: エンティティへのフォロワー追加・削除
4. **ファイル添付**: メッセージへのファイル添付
5. **フィルタリング**: メッセージタイプ、日付範囲、ピン留め等によるフィルタ
6. **ピン留め**: 重要メッセージのピン留め
7. **アクティビティプラン**: 複数アクティビティの一括登録

### 2.2 処理フロー

#### メッセージ投稿フロー
```
[開始]
   |
   v
[チャッターパネル表示]
   |
   v
[メッセージ入力]
   |
   v
[投稿ボタンクリック]
   |
   v
[messagesテーブルにレコード作成]
   |
   v
[フォロワーへの通知（オプション）]
   |
   v
[パネル更新]
   |
   v
[終了]
```

#### アクティビティ完了フロー
```
[開始]
   |
   v
[アクティビティ一覧表示]
   |
   v
[「完了」ボタンクリック]
   |
   v
[フィードバック入力（オプション）]
   |
   v
[完了コメントをメッセージとして投稿]
   |
   v
[アクティビティレコード削除]
   |
   v
[パネル更新]
   |
   v
[終了]
```

### 2.3 入力仕様

#### メッセージ投稿

| 入力項目 | 型 | 必須 | バリデーション | 説明 |
|----------|-----|------|---------------|------|
| type | string | YES | in:comment,note,notification,activity | メッセージタイプ |
| body | string | YES | - | メッセージ本文（HTML） |
| subject | string | NO | max:255 | 件名 |

#### アクティビティ登録

| 入力項目 | 型 | 必須 | バリデーション | 説明 |
|----------|-----|------|---------------|------|
| activity_type_id | integer | YES | exists:activity_types,id | アクティビティタイプID |
| activity_plan_id | integer | NO | exists:activity_plans,id | アクティビティプランID |
| date_deadline | date | NO | date | 期限日 |
| summary | string | NO | max:255 | 概要 |
| assigned_to | integer | YES | exists:users,id | 担当者ID |
| body | string | NO | - | 詳細本文 |

### 2.4 出力仕様

#### メッセージ

| 出力項目 | 型 | 説明 |
|----------|-----|------|
| id | integer | メッセージID |
| type | string | メッセージタイプ |
| subject | string | 件名 |
| body | string | 本文 |
| user | object | 投稿者情報 |
| pinned_at | datetime | ピン留め日時 |
| read_at | datetime | 既読日時 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

#### アクティビティ

| 出力項目 | 型 | 説明 |
|----------|-----|------|
| id | integer | アクティビティID |
| activity_type | object | アクティビティタイプ |
| date_deadline | date | 期限日 |
| summary | string | 概要 |
| assigned_to | object | 担当者情報 |
| body | string | 詳細本文 |

### 2.5 フィルタオプション

| フィルタ | 型 | 説明 |
|----------|-----|------|
| search | string | キーワード検索 |
| filterType | string | タイプフィルタ（all, comment, note, notification） |
| dateRange | string | 日付範囲（today, yesterday, week, month, quarter, year） |
| pinnedOnly | boolean | ピン留めのみ |
| sortBy | string | ソート順（created_at_desc, created_at_asc, updated_at_desc, priority） |

## 3. ビジネスルール

| No | ルール | 説明 |
|----|--------|------|
| BR-001 | Polymorphic関連 | メッセージは任意のモデルに紐付け可能（messagable） |
| BR-002 | タイプ別表示 | メッセージタイプにより表示スタイルが異なる |
| BR-003 | ピン留め優先 | ピン留めメッセージはソート結果の先頭に表示 |
| BR-004 | アクティビティ完了 | 完了時にコメントとして履歴を残す |
| BR-005 | フォロワー通知 | フォロワーにはメール通知が送信される（設定による） |

## 4. データ設計

### 4.1 使用テーブル

| テーブル名 | 用途 | 操作 |
|------------|------|------|
| messages | メッセージ・アクティビティ管理 | SELECT, INSERT, UPDATE, DELETE |
| activity_types | アクティビティタイプマスタ | SELECT |
| activity_plans | アクティビティプランマスタ | SELECT |
| followers | フォロワー管理 | SELECT, INSERT, DELETE |
| users | ユーザー参照 | SELECT |
| partners | パートナー参照（フォロワー） | SELECT |

### 4.2 テーブル定義（messages - 主要カラム）

| カラム名 | データ型 | NULL許可 | デフォルト | 説明 |
|----------|----------|----------|------------|------|
| id | bigint | NO | auto | 主キー |
| type | varchar(50) | NO | - | メッセージタイプ |
| subject | varchar(255) | YES | NULL | 件名 |
| body | text | YES | NULL | 本文 |
| messagable_type | varchar(255) | NO | - | 関連モデルタイプ |
| messagable_id | bigint | NO | - | 関連モデルID |
| activity_type_id | bigint | YES | NULL | アクティビティタイプID |
| activity_plan_id | bigint | YES | NULL | アクティビティプランID |
| date_deadline | date | YES | NULL | 期限日 |
| summary | varchar(255) | YES | NULL | 概要 |
| assigned_to | bigint | YES | NULL | 担当者ID |
| pinned_at | timestamp | YES | NULL | ピン留め日時 |
| read_at | timestamp | YES | NULL | 既読日時 |
| user_id | bigint | YES | NULL | 投稿者ID |
| created_at | timestamp | YES | - | 作成日時 |
| updated_at | timestamp | YES | - | 更新日時 |

## 5. 関連コンポーネント

### 5.1 主要クラス

| クラス名 | パス | 役割 |
|----------|------|------|
| ChatterPanel | plugins/webkul/chatter/src/Livewire/ChatterPanel.php | チャッターパネルLivewireコンポーネント |
| Message | plugins/webkul/chatter/src/Models/Message.php | メッセージモデル |
| HasChatter | plugins/webkul/chatter/src/Traits/HasChatter.php | チャッター機能トレイト |
| FileAction | plugins/webkul/chatter/src/Filament/Actions/Chatter/FileAction.php | ファイル添付アクション |
| FollowerAction | plugins/webkul/chatter/src/Filament/Actions/Chatter/FollowerAction.php | フォロワー管理アクション |
| FiltersAction | plugins/webkul/chatter/src/Filament/Actions/Chatter/FiltersAction.php | フィルタアクション |

### 5.2 依存モジュール

| モジュール名 | 依存関係 |
|--------------|----------|
| webkul/chatter | 必須（チャッター基盤） |
| webkul/partner | 必須（フォロワー管理） |
| webkul/security | 必須（ユーザー管理） |
| webkul/support | 必須（ActivityType, ActivityPlan） |
| filament/filament | 必須（UI基盤） |
| livewire/livewire | 必須（リアクティブUI） |

## 6. セキュリティ

### 6.1 アクセス制御

| 操作 | 条件 |
|------|------|
| メッセージ閲覧 | 関連エンティティへのアクセス権限 |
| メッセージ投稿 | ログインユーザー |
| メッセージ削除 | 投稿者本人または管理者 |
| ピン留め | 投稿者本人または管理者 |
| フォロワー管理 | 関連エンティティへの編集権限 |

### 6.2 セキュリティ考慮事項

- 本文のサニタイズ（XSS対策）
- ファイルアップロードの検証
- フォロワーメール送信時のプライバシー保護

## 7. 非機能要件

### 7.1 パフォーマンス

| 項目 | 要件 |
|------|------|
| パネル読み込み速度 | 1秒以内 |
| メッセージ投稿応答時間 | 500ms以内 |
| リアルタイム更新 | Livewire dispatch による即時更新 |

### 7.2 可用性

- Livewireによるリアクティブ更新
- プレースホルダー表示による体感速度向上

## 8. 例外処理

| エラーコード | エラー内容 | 対応 |
|--------------|------------|------|
| CHAT-001 | メッセージ投稿失敗 | エラー通知表示 |
| CHAT-002 | アクティビティ作成失敗 | エラー通知表示 |
| CHAT-003 | フォロワー追加失敗 | エラー通知表示 |
| CHAT-004 | ファイルアップロード失敗 | エラー通知表示 |

## 9. テスト観点

| No | テスト項目 | 確認内容 |
|----|------------|----------|
| T-001 | メッセージ投稿 | 各タイプのメッセージが投稿できること |
| T-002 | アクティビティ登録 | アクティビティが登録できること |
| T-003 | アクティビティ完了 | 完了処理が正しく動作すること |
| T-004 | フィルタリング | 各フィルタが正しく動作すること |
| T-005 | ピン留め | ピン留め/解除が動作すること |
| T-006 | フォロワー管理 | フォロワー追加/削除が動作すること |
| T-007 | ファイル添付 | ファイルが添付できること |
| T-008 | リアルタイム更新 | メッセージ投稿後にパネルが更新されること |

## 10. 改訂履歴

| 版数 | 日付 | 変更者 | 変更内容 |
|------|------|--------|----------|
| 1.0 | 2025-12-26 | 自動生成 | 初版作成 |
