# 機能設計書 F090-活動タイプ管理（採用）

## 概要

本ドキュメントは、AureusERP採用管理モジュールにおける活動タイプ管理機能の設計を定義するものです。採用プロセスで実行される活動（面接、電話連絡、書類確認等）の種類を定義・管理します。

### 本機能の処理概要

**業務上の目的・背景**：採用活動において、応募者に対して行う様々なアクション（面接設定、フォローアップ電話、オファーレター送付等）を体系的に管理する必要があります。本機能は、活動タイプを定義し、スケジューリング、通知、自動チェーン化などの機能を提供することで、採用プロセスの効率化と標準化を実現します。

**機能の利用シーン**：
- 人事担当者が活動タイプマスタを設定する場面
- 応募者への活動（面接、電話等）を登録する場面
- 活動の自動リマインダーを設定する場面
- 活動完了後の次アクションを自動設定する場面
- 活動プランを構成する場面

**主要な処理内容**：
1. 活動タイプの作成・編集・削除
2. 活動タイプ名・アイコン・装飾タイプの設定
3. 遅延設定（delay_count, delay_unit, delay_from）
4. チェーン設定（次の活動タイプの自動設定）
5. デフォルト担当者の設定
6. 活動プランとの関連

**関連システム・外部連携**：
- サポートモジュール：活動タイプマスタを共有（BaseActivityTypeを継承）
- 応募者モジュール：応募者への活動管理で使用
- 活動プランモジュール：プランの構成要素として使用

**権限による制御**：ActivityTypePolicyによる権限管理が適用されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-REC-014 | ActivityTypeResource | 主画面 | 活動タイプの一覧表示・作成・編集・削除・表示 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 活動タイプ名 | - |
| icon | string | No | アイコン | - |
| decoration_type | string | No | 装飾タイプ | - |
| category | string | No | カテゴリ | - |
| summary | string | No | 概要 | - |
| default_note | string | No | デフォルトノート | - |
| delay_count | integer | No | 遅延カウント | 正の整数 |
| delay_unit | string | No | 遅延単位 | days/weeks/months |
| delay_from | string | No | 遅延起点 | - |
| chaining_type | string | No | チェーンタイプ | - |
| triggered_next_type_id | integer | No | 次の活動タイプID | 存在する活動タイプID |
| default_user_id | integer | No | デフォルト担当者ID | 存在するユーザーID |
| activity_plan_id | integer | No | 活動プランID | 存在する活動プランID |
| is_active | boolean | No | 有効フラグ | デフォルト: true |
| keep_done | boolean | No | 完了後も保持 | デフォルト: false |
| creator_id | integer | Yes | 作成者ID | ログインユーザーID（自動設定） |

### 入力データソース

- 画面フォーム入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 活動タイプID |
| name | string | 活動タイプ名 |
| icon | string | アイコン |
| decoration_type | string | 装飾タイプ |
| category | string | カテゴリ |
| delay_count | integer | 遅延カウント |
| delay_unit | string | 遅延単位 |
| chaining_type | string | チェーンタイプ |
| triggeredNextType.name | string | 次の活動タイプ名 |
| defaultUser.name | string | デフォルト担当者名 |
| activityPlan.name | string | 活動プラン名 |
| is_active | boolean | 有効フラグ |
| sort | integer | 並び順 |
| createdBy.name | string | 作成者名 |

### 出力先

- 画面表示（一覧・詳細・編集フォーム）
- データベーステーブル（activity_types）

## 処理フロー

### 処理シーケンス

```
1. 活動タイプ一覧表示
   └─ ソート順に基づいてデータ取得
2. 活動タイプ作成
   └─ フォーム入力 → バリデーション → DB保存 → ソート自動付与
3. 活動タイプ編集
   └─ 既存データ取得 → 編集 → 更新
4. 活動タイプ削除
   └─ 論理削除（SoftDelete）実行
5. チェーン設定
   └─ 次の活動タイプを選択 → 自動遷移設定
```

### フローチャート

```mermaid
flowchart TD
    A[活動タイプ管理開始] --> B[一覧表示]
    B --> C{操作選択}
    C -->|作成| D[作成フォーム]
    C -->|編集| E[編集画面]
    C -->|表示| F[詳細画面]
    C -->|削除| G[論理削除]
    D --> H{チェーン設定?}
    H -->|Yes| I[次タイプ選択]
    H -->|No| J[保存]
    I --> J
    E --> J
    G --> B
    J --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-090-01 | ソート自動付与 | 作成時に自動でsort値を付与 | SortableTrait使用 |
| BR-090-02 | 論理削除 | 削除時は物理削除せずソフトデリート | SoftDeletesトレイト使用 |
| BR-090-03 | 共有マスタ | サポートモジュールと活動タイプマスタを共有 | 常時 |
| BR-090-04 | チェーン自動化 | 活動完了時に次の活動タイプを自動作成 | triggered_next_type_id設定時 |
| BR-090-05 | 遅延計算 | delay_count + delay_unitで期日を自動計算 | 遅延設定時 |
| BR-090-06 | プラグイン識別 | plugin=recruitmentsで採用専用を識別 | 常時 |

### 計算ロジック

- 活動期日 = 起点日 + (delay_count × delay_unit)
  - 例：delay_count=3, delay_unit=days → 3日後

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 活動タイプ作成 | activity_types | INSERT | 活動タイプレコード作成 |
| 活動タイプ更新 | activity_types | UPDATE | 活動タイプ情報更新 |
| 活動タイプ削除 | activity_types | UPDATE | ソフトデリート（deleted_at設定） |
| 並び替え | activity_types | UPDATE | sort値の更新 |

### テーブル別操作詳細

#### activity_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | 必須 |
| INSERT/UPDATE | icon | フォーム入力値 | |
| INSERT/UPDATE | decoration_type | フォーム入力値 | |
| INSERT/UPDATE | category | フォーム入力値 | |
| INSERT/UPDATE | delay_count | フォーム入力値 | |
| INSERT/UPDATE | delay_unit | フォーム入力値 | |
| INSERT/UPDATE | delay_from | フォーム入力値 | |
| INSERT/UPDATE | chaining_type | フォーム入力値 | |
| INSERT/UPDATE | triggered_next_type_id | 選択された活動タイプID | |
| INSERT/UPDATE | default_user_id | 選択されたユーザーID | |
| INSERT/UPDATE | is_active | フォーム入力値 | デフォルト: true |
| INSERT/UPDATE | keep_done | フォーム入力値 | デフォルト: false |
| INSERT | plugin | 'recruitments' | 自動設定 |
| INSERT | creator_id | 認証ユーザーID | 自動設定 |
| INSERT | sort | SortableTraitによる自動計算 | 自動設定 |
| DELETE | deleted_at | 現在日時 | ソフトデリート |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E090-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E090-02 | 参照エラー | 存在しない関連ID | エラーメッセージ表示 |
| E090-03 | 循環参照エラー | チェーン設定で循環参照 | 警告メッセージ表示 |

### リトライ仕様

特になし（同期処理）

## トランザクション仕様

単純なCRUD操作のため、標準的なトランザクション処理で対応します。

## パフォーマンス要件

- 一覧表示：1秒以内のレスポンス
- マスタデータのため、通常は少量のレコード

## セキュリティ考慮事項

- ActivityTypePolicyによるアクセス制御
- 認証ユーザーのみアクセス可能
- Configurationsクラスター配下で管理者機能として提供
- 作成者情報（creator_id）の自動記録
- 論理削除によるデータ保全

## 備考

- サポートモジュールのActivityTypeResourceを継承（BaseActivityTypeResource）
- 採用モジュール用にクラスター設定、ページ、pluginNameをオーバーライド
- pluginName = 'recruitments'で採用専用の活動タイプを識別
- Spatie EloquentSortableパッケージを使用した並び替え
- SoftDeletesによる論理削除で履歴データを保全
- suggestedActivityTypes関連：推奨される次の活動タイプを多対多で管理
- activityTypes関連：自己参照でチェーン構造を形成
