# 機能設計書 91-活動プラン管理（採用）

## 概要

本ドキュメントは、採用モジュールにおける活動プラン管理機能の設計仕様を定義します。

### 本機能の処理概要

採用活動プラン管理機能は、採用プロセスにおける一連の活動（面接設定、連絡、評価など）をテンプレート化して管理する機能です。

**業務上の目的・背景**：
採用プロセスでは、応募者に対して複数の活動（面接スケジュール、フォローアップ連絡、評価面談など）を計画的に実行する必要があります。これらの活動を毎回手動で設定することは非効率であり、採用担当者の負担となります。活動プラン機能により、標準化された採用プロセスをテンプレートとして定義し、応募者に対して一括適用することで、採用業務の効率化と品質の均一化を実現します。

**機能の利用シーン**：
- 新規採用プロセスの開始時に、標準的な活動プランを応募者に適用する
- 部門・職種別の採用プロセスをテンプレートとして管理する
- 活動プランの内容を編集・更新して、採用プロセスを改善する

**主要な処理内容**：
1. 活動プランの一覧表示・検索・フィルタリング
2. 活動プランの新規作成（名前、部門、会社、有効/無効ステータス）
3. 活動プランの編集・更新
4. 活動プランの詳細表示
5. 活動プランの削除・復元・完全削除
6. 活動テンプレートの関連管理

**関連システム・外部連携**：
- 従業員モジュール（employees）：ベース活動プラン機能の継承
- 部門管理機能：活動プランと部門の紐付け
- 会社管理機能：活動プランと会社の紐付け

**権限による制御**：
ActivityPlanPolicyにより、活動プランに対するCRUD操作の権限が制御されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-REC-CONFIG-001 | ActivityPlanResource | 主画面 | 活動プランの一覧表示・CRUD操作 |
| SCR-REC-CONFIG-001 | ListActivityPlans | 参照画面 | 活動プランの一覧表示 |
| SCR-REC-CONFIG-001 | EditActivityPlan | 参照画面 | 活動プランの編集 |
| SCR-REC-CONFIG-001 | ViewActivityPlan | 参照画面 | 活動プランの詳細表示 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 活動プラン名 | 最大255文字 |
| department_id | integer | No | 部門ID | 存在する部門IDであること |
| company_id | integer | No | 会社ID | 存在する会社IDであること |
| is_active | boolean | No | 有効/無効ステータス | デフォルト: true |
| plugin | string | No | プラグイン識別子 | 自動設定: "recruitments" |
| creator_id | integer | No | 作成者ID | ログインユーザーIDが自動設定 |

### 入力データソース

- 画面入力（Filament フォーム）
- 認証情報（ログインユーザー）
- 既存マスタデータ（部門、会社）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 活動プランID |
| name | string | 活動プラン名 |
| department.name | string | 関連部門名 |
| department.manager.name | string | 部門マネージャー名 |
| company.name | string | 関連会社名 |
| is_active | boolean | 有効/無効ステータス |
| createdBy.name | string | 作成者名 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（Filament テーブル/フォーム/インフォリスト）
- データベース（employees_activity_plans テーブル）

## 処理フロー

### 処理シーケンス

```
1. 一覧表示
   └─ plugin='recruitments'の条件でActivityPlanを取得・表示
2. 新規作成
   └─ フォーム入力 → plugin='recruitments'を自動設定 → 保存
3. 編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. 削除
   └─ ソフトデリート実行 → 通知表示
5. 復元
   └─ ソフトデリート解除 → 通知表示
6. 完全削除
   └─ 物理削除実行 → 通知表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[一覧画面表示]
    B --> C{操作選択}
    C -->|新規作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|表示| F[詳細画面表示]
    C -->|削除| G[削除確認]
    C -->|復元| H[復元処理]
    C -->|完全削除| I[完全削除確認]
    D --> J[バリデーション]
    E --> J
    J -->|成功| K[DB保存]
    J -->|失敗| L[エラー表示]
    G --> M[ソフトデリート]
    H --> N[復元処理]
    I --> O[物理削除]
    K --> P[成功通知]
    M --> P
    N --> P
    O --> P
    L --> B
    P --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-091-01 | プラグイン識別 | 活動プランのpluginフィールドは'recruitments'固定 | 作成時・クエリ時 |
| BR-091-02 | 作成者自動設定 | creator_idはログインユーザーIDが自動設定される | 新規作成時 |
| BR-091-03 | 会社デフォルト | company_idが未設定の場合、ログインユーザーのデフォルト会社が設定される | 新規作成時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | employees_activity_plans | SELECT | plugin='recruitments'で抽出 |
| 新規作成 | employees_activity_plans | INSERT | 活動プランの新規登録 |
| 編集 | employees_activity_plans | UPDATE | 活動プランの更新 |
| 削除 | employees_activity_plans | UPDATE | deleted_atにタイムスタンプ設定 |
| 復元 | employees_activity_plans | UPDATE | deleted_atをNULLに設定 |
| 完全削除 | employees_activity_plans | DELETE | レコードの物理削除 |

### テーブル別操作詳細

#### employees_activity_plans

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE plugin = 'recruitments' | 採用プラン限定抽出 |
| INSERT | name, department_id, company_id, is_active, plugin, creator_id | フォーム入力値 + 自動設定値 | |
| UPDATE | name, department_id, company_id, is_active | フォーム入力値 | |
| UPDATE | deleted_at | CURRENT_TIMESTAMP | ソフトデリート |
| UPDATE | deleted_at | NULL | 復元 |
| DELETE | - | WHERE id = {record_id} | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-091-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-091-02 | 参照整合性エラー | 削除済み部門・会社を選択 | 有効な値を選択するよう促す |
| E-091-03 | 削除エラー | 関連データが存在する場合 | 関連データの削除または解除を促す |

### リトライ仕様

特になし

## トランザクション仕様

- 各CRUD操作は単一トランザクションで実行
- エラー発生時は自動ロールバック

## パフォーマンス要件

- 一覧表示: 1秒以内
- 作成/更新: 2秒以内

## セキュリティ考慮事項

- ActivityPlanPolicyによる権限制御
- ログインユーザーのみ操作可能
- 監査ログ（作成者・更新日時）の記録

## 備考

- 本機能は従業員モジュールのActivityPlanResourceを継承しています
- 採用モジュール専用のフィルタリング（plugin='recruitments'）が適用されます
