# 機能設計書 92-部門管理（採用）

## 概要

本ドキュメントは、採用モジュールにおける部門管理機能の設計仕様を定義します。

### 本機能の処理概要

採用部門管理機能は、採用活動に関連する部門情報を管理する機能です。従業員モジュールの部門管理機能を継承し、採用プロセスに特化した設定を提供します。

**業務上の目的・背景**：
採用活動は特定の部門で発生するポジションに対して行われます。部門ごとに採用担当者、採用プロセス、求人数などが異なるため、採用モジュール内で部門情報を参照・管理できることが重要です。本機能により、採用担当者は採用対象の部門情報を容易に把握し、適切な採用活動を計画・実行できます。

**機能の利用シーン**：
- 採用対象部門の登録・編集
- 部門別の採用状況確認
- 部門マネージャーの設定
- 部門の従業員一覧確認

**主要な処理内容**：
1. 部門の一覧表示（カード形式）
2. 部門の新規作成
3. 部門の編集・更新
4. 部門の詳細表示
5. 部門所属従業員の管理
6. 部門の削除・復元・完全削除

**関連システム・外部連携**：
- 従業員モジュール（employees）：ベース部門管理機能の継承
- 会社管理機能：部門と会社の紐付け
- 従業員管理機能：部門と従業員の紐付け

**権限による制御**：
DepartmentPolicyにより、部門に対するCRUD操作の権限が制御されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-REC-012 | DepartmentResource | 主画面 | 部門の一覧表示・CRUD操作 |
| SCR-REC-012 | ListDepartments | 参照画面 | 部門の一覧表示 |
| SCR-REC-012 | CreateDepartment | 参照画面 | 部門の新規作成 |
| SCR-REC-012 | EditDepartment | 参照画面 | 部門の編集 |
| SCR-REC-012 | ViewDepartment | 参照画面 | 部門の詳細表示 |
| SCR-REC-012 | ManageEmployee | 参照画面 | 部門従業員の管理 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 部門名 | 最大255文字 |
| parent_id | integer | No | 親部門ID | 存在する部門IDであること |
| manager_id | integer | No | マネージャーID | 存在する従業員IDであること |
| company_id | integer | No | 会社ID | 存在する会社IDであること |
| color | string | No | 表示カラー | 16進数カラーコード |
| creator_id | integer | No | 作成者ID | ログインユーザーIDが自動設定 |

### 入力データソース

- 画面入力（Filament フォーム）
- 認証情報（ログインユーザー）
- 既存マスタデータ（親部門、マネージャー、会社）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 部門ID |
| name | string | 部門名 |
| complete_name | string | 完全部門名（階層含む） |
| parent.name | string | 親部門名 |
| manager.name | string | マネージャー名 |
| manager.partner.avatar | string | マネージャーアバター画像 |
| company.name | string | 会社名 |
| color | string | 表示カラー |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（Filament テーブル（カード形式）/フォーム/インフォリスト）
- データベース（employees_departments テーブル）

## 処理フロー

### 処理シーケンス

```
1. 一覧表示
   └─ 部門データをカードグリッド形式で表示
2. 新規作成
   └─ フォーム入力 → creator_id自動設定 → 保存
3. 編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. 詳細表示
   └─ 部門情報 + 階層構造ツリー表示
5. 従業員管理
   └─ 部門所属従業員の一覧・管理
6. 削除/復元
   └─ ソフトデリート/復元処理
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[一覧画面表示]
    B --> C{操作選択}
    C -->|新規作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|表示| F[詳細画面表示]
    C -->|従業員管理| G[従業員管理画面]
    C -->|削除| H[削除確認]
    D --> I[バリデーション]
    E --> I
    I -->|成功| J[DB保存]
    I -->|失敗| K[エラー表示]
    F --> L[階層ツリー表示]
    G --> M[従業員一覧表示]
    H --> N[ソフトデリート]
    J --> O[成功通知]
    N --> O
    K --> B
    O --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-092-01 | 作成者自動設定 | creator_idはログインユーザーIDが自動設定される | 新規作成時 |
| BR-092-02 | 階層構造 | 部門は親子関係を持つ階層構造で管理可能 | 常時 |
| BR-092-03 | 完全名称 | complete_nameは階層を含む完全部門名として自動生成 | 常時 |
| BR-092-04 | 削除済み選択不可 | 削除済みの親部門・会社は選択不可（表示はされる） | フォーム選択時 |

### 計算ロジック

- 従業員数カウント: 部門に所属する従業員数を動的に算出

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | employees_departments | SELECT | 全部門を取得 |
| 新規作成 | employees_departments | INSERT | 部門の新規登録 |
| 編集 | employees_departments | UPDATE | 部門の更新 |
| 詳細表示 | employees_departments | SELECT | 階層含む情報取得 |
| 従業員管理 | employees | SELECT | 部門所属従業員取得 |
| 削除 | employees_departments | UPDATE | deleted_atにタイムスタンプ設定 |
| 復元 | employees_departments | UPDATE | deleted_atをNULLに設定 |
| 完全削除 | employees_departments | DELETE | レコードの物理削除 |

### テーブル別操作詳細

#### employees_departments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | 全件または条件指定 | リレーション含む |
| INSERT | name, parent_id, manager_id, company_id, color, creator_id | フォーム入力値 | |
| UPDATE | name, parent_id, manager_id, company_id, color | フォーム入力値 | |
| UPDATE | deleted_at | CURRENT_TIMESTAMP | ソフトデリート |
| UPDATE | deleted_at | NULL | 復元 |
| DELETE | - | WHERE id = {record_id} | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-092-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-092-02 | 参照整合性エラー | 削除済み親部門・会社を選択 | 有効な値を選択するよう促す |
| E-092-03 | 循環参照エラー | 自身を親部門に設定 | エラーメッセージ表示 |

### リトライ仕様

特になし

## トランザクション仕様

- 各CRUD操作は単一トランザクションで実行
- エラー発生時は自動ロールバック

## パフォーマンス要件

- 一覧表示: 1秒以内
- 作成/更新: 2秒以内
- 階層ツリー表示: 2秒以内

## セキュリティ考慮事項

- DepartmentPolicyによる権限制御
- ログインユーザーのみ操作可能
- 監査ログ（作成者・更新日時）の記録

## 備考

- 本機能は従業員モジュールのDepartmentResourceを継承しています
- 一覧画面はカードグリッド形式（md: 2列, xl: 3列）で表示されます
- サブナビゲーション機能で詳細・編集・従業員管理間を移動できます
