# 機能設計書 93-休暇申請管理

## 概要

本ドキュメントは、休暇管理モジュールにおける休暇申請管理機能の設計仕様を定義します。

### 本機能の処理概要

休暇申請管理機能は、全従業員の休暇申請を管理者・人事担当者が一元管理するための機能です。申請の作成、確認、承認、却下などのワークフロー管理を提供します。

**業務上の目的・背景**：
従業員の休暇取得を適切に管理することは、組織の人員配置や業務計画において重要です。本機能により、人事担当者や管理者は全従業員の休暇申請状況を把握し、承認ワークフローを通じて適切な休暇管理を行うことができます。また、休暇タイプ別の集計や従業員別の休暇取得状況の確認が可能となり、労務管理の効率化に寄与します。

**機能の利用シーン**：
- 管理者による従業員の休暇申請確認・承認・却下
- 新規休暇申請の代行作成
- 休暇申請状況のモニタリング
- 休暇タイプ別・従業員別のグループ表示

**主要な処理内容**：
1. 休暇申請の一覧表示・検索・フィルタリング・グループ化
2. 休暇申請の新規作成（従業員指定可能）
3. 休暇申請の編集・更新
4. 休暇申請の詳細表示
5. 休暇申請の承認・却下
6. 休暇申請の削除

**関連システム・外部連携**：
- 従業員モジュール：従業員情報の参照
- 休暇タイプ管理：休暇種別の参照
- カレンダー機能：勤務カレンダーとの連携

**権限による制御**：
管理者・人事担当者など、適切な権限を持つユーザーのみがアクセス可能です。State（状態）に応じて編集・承認・却下アクションの表示が制御されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-TOFF-001 | TimeOffResource | 主画面 | 休暇申請の一覧表示・CRUD操作 |
| SCR-TOFF-001 | ListTimeOff | 参照画面 | 休暇申請の一覧表示 |
| SCR-TOFF-001 | CreateTimeOff | 参照画面 | 休暇申請の新規作成 |
| SCR-TOFF-001 | EditTimeOff | 参照画面 | 休暇申請の編集 |
| SCR-TOFF-001 | ViewTimeOff | 参照画面 | 休暇申請の詳細表示 |

## 機能種別

CRUD操作 / ワークフロー管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| employee_id | integer | Yes | 従業員ID | 存在する従業員IDであること |
| holiday_status_id | integer | Yes | 休暇タイプID | 存在する休暇タイプIDであること |
| request_date_from | date | Yes | 開始日 | 有効な日付 |
| request_date_to | date | No | 終了日（半日休暇時は不要） | 開始日以降 |
| request_unit_half | boolean | No | 半日休暇フラグ | |
| request_date_from_period | enum | No | 半日の時間帯（午前/午後） | 半日休暇時のみ |
| private_name | string | No | 説明・理由 | |
| attachment | file | No | 添付ファイル | 休暇タイプで要求される場合 |
| state | enum | No | 状態 | State Enum値 |

### 入力データソース

- 画面入力（Filament フォーム）
- TimeOffHelper トレイトによるフォーム構築
- 既存マスタデータ（従業員、休暇タイプ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 休暇申請ID |
| employee.name | string | 従業員名 |
| holidayStatus.name | string | 休暇タイプ名 |
| private_name | string | 説明・理由 |
| date_from | datetime | 開始日時 |
| date_to | datetime | 終了日時 |
| duration_display | string | 期間表示 |
| state | enum | 状態（下書き/申請中/承認済み等） |

### 出力先

- 画面表示（Filament テーブル/フォーム/インフォリスト）
- データベース（time_off_leaves テーブル）

## 処理フロー

### 処理シーケンス

```
1. 一覧表示
   └─ 休暇申請データを取得・表示（グループ化可能）
2. 新規作成
   └─ フォーム入力 → バリデーション → 状態設定 → 保存
3. 編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. 承認
   └─ 状態をVALIDATE_TWOに更新 → 通知表示
5. 却下
   └─ 状態をREFUSEに更新 → 通知表示
6. 削除
   └─ レコード削除 → 通知表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[一覧画面表示]
    B --> C{操作選択}
    C -->|新規作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|表示| F[詳細画面表示]
    C -->|承認| G[承認処理]
    C -->|却下| H[却下処理]
    C -->|削除| I[削除確認]
    D --> J[バリデーション]
    E --> J
    J -->|成功| K[DB保存]
    J -->|失敗| L[エラー表示]
    G --> M[状態更新: VALIDATE_TWO]
    H --> N[状態更新: REFUSE]
    I --> O[レコード削除]
    K --> P[成功通知]
    M --> P
    N --> P
    O --> P
    L --> B
    P --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-093-01 | 状態遷移 | 状態はCONFIRM→VALIDATE_ONE→VALIDATE_TWOまたはREFUSEの順で遷移 | 承認/却下時 |
| BR-093-02 | 承認済み非表示 | 既に最終承認済み（VALIDATE_TWO）の申請は承認ボタン非表示 | 一覧アクション |
| BR-093-03 | 却下済み非表示 | 既に却下済み（REFUSE）の申請は却下ボタン非表示 | 一覧アクション |
| BR-093-04 | 半日休暇 | 半日休暇の場合、終了日は不要で期間は0.5日 | フォーム入力時 |
| BR-093-05 | 添付ファイル | 休暇タイプでsupport_documentがtrueの場合、添付ファイルを表示 | 詳細表示時 |

### 計算ロジック

- 休暇日数計算: request_date_fromとrequest_date_toの差分 + 1日
- 半日休暇: 0.5日として計算

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | time_off_leaves | SELECT | 休暇申請を取得 |
| 新規作成 | time_off_leaves | INSERT | 休暇申請の新規登録 |
| 編集 | time_off_leaves | UPDATE | 休暇申請の更新 |
| 承認/却下 | time_off_leaves | UPDATE | stateカラムの更新 |
| 削除 | time_off_leaves | DELETE | レコードの削除 |

### テーブル別操作詳細

#### time_off_leaves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | 条件指定 | リレーション含む |
| INSERT | employee_id, holiday_status_id, request_date_from, request_date_to, state, 他 | フォーム入力値 | |
| UPDATE | state | VALIDATE_TWO | 承認時 |
| UPDATE | state | REFUSE | 却下時 |
| DELETE | - | WHERE id = {record_id} | 削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-093-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-093-02 | 日付エラー | 終了日が開始日より前 | 正しい日付を入力するよう促す |
| E-093-03 | 重複エラー | 同一期間に既存申請あり | 期間の調整を促す |

### リトライ仕様

特になし

## トランザクション仕様

- 各CRUD操作・状態更新は単一トランザクションで実行
- エラー発生時は自動ロールバック

## パフォーマンス要件

- 一覧表示: 1秒以内
- 作成/更新: 2秒以内
- 承認/却下: 1秒以内

## セキュリティ考慮事項

- 管理者・人事担当者権限による制御
- 休暇申請内容の機密性確保（private_name）
- 監査ログ（HasLogActivity トレイト）による操作履歴記録

## 備考

- TimeOffHelperトレイトによりフォームスキーマが共通化されています
- State Enumにより状態管理が行われます（CONFIRM, VALIDATE_ONE, VALIDATE_TWO, REFUSE）
- HasChatterトレイトによりコメント・活動ログ機能が利用可能です
