# 機能設計書 94-自分の休暇管理

## 概要

本ドキュメントは、休暇管理モジュールにおける「自分の休暇管理」機能の設計仕様を定義します。

### 本機能の処理概要

自分の休暇管理機能は、ログインユーザー自身の休暇申請を管理するための機能です。自分専用のビューで休暇の申請、確認、取り消しを行えます。

**業務上の目的・背景**：
従業員は自身の休暇を申請・管理するためのセルフサービス機能を必要とします。本機能により、従業員は管理者を介さずに休暇申請を作成し、自身の申請履歴を確認することができます。また、まだ承認されていない申請については取り消しや編集が可能です。

**機能の利用シーン**：
- 従業員が休暇を申請する
- 自分の休暇申請履歴を確認する
- 申請中の休暇を取り消す・編集する
- 承認状況を確認する

**主要な処理内容**：
1. 自分の休暇申請一覧表示（ログインユーザーのみ）
2. 新規休暇申請の作成
3. 申請の編集・更新
4. 申請の詳細表示
5. 申請の削除（下書き・申請中のみ）

**関連システム・外部連携**：
- 従業員モジュール：従業員情報（ログインユーザーと紐付く従業員）
- 休暇タイプ管理：休暇種別の参照
- カレンダー機能：勤務カレンダーとの連携

**権限による制御**：
ログインユーザー自身の申請データのみに限定されます。他ユーザーの申請は表示されません。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-TOFF-MY-001 | MyTimeOffResource | 主画面 | 自分の休暇申請の一覧表示・CRUD操作 |
| SCR-TOFF-MY-001 | ListMyTimeOff | 参照画面 | 自分の休暇申請の一覧表示 |
| SCR-TOFF-MY-001 | CreateMyTimeOff | 参照画面 | 休暇申請の新規作成 |
| SCR-TOFF-MY-001 | EditMyTimeOff | 参照画面 | 休暇申請の編集 |
| SCR-TOFF-MY-001 | ViewMyTimeOff | 参照画面 | 休暇申請の詳細表示 |

## 機能種別

CRUD操作 / セルフサービス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| holiday_status_id | integer | Yes | 休暇タイプID | 存在する休暇タイプIDであること |
| request_date_from | date | Yes | 開始日 | 有効な日付 |
| request_date_to | date | No | 終了日 | 開始日以降 |
| request_unit_half | boolean | No | 半日休暇フラグ | |
| request_date_from_period | enum | No | 半日の時間帯 | 半日休暇時のみ |
| private_name | string | No | 説明・理由 | |
| attachment | file | No | 添付ファイル | 休暇タイプで要求される場合 |

### 入力データソース

- 画面入力（Filament フォーム）
- 認証情報（ログインユーザーの従業員情報）
- 既存マスタデータ（休暇タイプ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 休暇申請ID |
| holidayStatus.name | string | 休暇タイプ名 |
| private_name | string | 説明・理由 |
| date_from | datetime | 開始日時 |
| date_to | datetime | 終了日時 |
| duration_display | string | 期間表示 |
| state | enum | 状態 |

### 出力先

- 画面表示（Filament テーブル/フォーム/インフォリスト）
- データベース（time_off_leaves テーブル）

## 処理フロー

### 処理シーケンス

```
1. 一覧表示
   └─ ログインユーザーの従業員IDで休暇申請をフィルタリング取得
2. 新規作成
   └─ フォーム入力 → ログインユーザーの従業員ID自動設定 → 保存
3. 編集
   └─ 既存データ取得（所有者チェック）→ フォーム編集 → 保存
4. 削除
   └─ 状態チェック → レコード削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ログインユーザー取得]
    B --> C[従業員ID取得]
    C --> D[一覧画面表示]
    D --> E{操作選択}
    E -->|新規作成| F[作成フォーム表示]
    E -->|編集| G[編集フォーム表示]
    E -->|表示| H[詳細画面表示]
    E -->|削除| I[削除確認]
    F --> J[バリデーション]
    G --> J
    J -->|成功| K[employee_id自動設定]
    K --> L[DB保存]
    J -->|失敗| M[エラー表示]
    I --> N{状態チェック}
    N -->|下書き/申請中| O[レコード削除]
    N -->|承認済み/却下| P[削除不可通知]
    L --> Q[成功通知]
    O --> Q
    M --> D
    P --> D
    Q --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-094-01 | ユーザーフィルタ | ログインユーザーの従業員IDに紐づく申請のみ表示 | 常時 |
| BR-094-02 | 従業員自動設定 | employee_idはログインユーザーの従業員IDが自動設定 | 新規作成時 |
| BR-094-03 | 編集可能状態 | 下書き・申請中の申請のみ編集可能 | 編集時 |
| BR-094-04 | 削除可能状態 | 承認済み・却下済みの申請は削除不可 | 削除時 |

### 計算ロジック

- 休暇日数計算: TimeOffResourceと同様

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | time_off_leaves | SELECT | ログインユーザーの申請を取得 |
| 新規作成 | time_off_leaves | INSERT | 休暇申請の新規登録 |
| 編集 | time_off_leaves | UPDATE | 休暇申請の更新 |
| 削除 | time_off_leaves | DELETE | レコードの削除 |

### テーブル別操作詳細

#### time_off_leaves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE employee_id = {current_employee_id} | ログインユーザー限定 |
| INSERT | employee_id, holiday_status_id, request_date_from, ... | ログインユーザーの従業員ID + フォーム入力値 | |
| UPDATE | 各カラム | フォーム入力値 | |
| DELETE | - | WHERE id = {record_id} | 削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-094-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-094-02 | 従業員未設定 | ログインユーザーに従業員が紐付いていない | 管理者に連絡を促す |
| E-094-03 | 削除不可エラー | 承認済み/却下済みの申請を削除しようとした | エラーメッセージ表示 |

### リトライ仕様

特になし

## トランザクション仕様

- 各CRUD操作は単一トランザクションで実行
- エラー発生時は自動ロールバック

## パフォーマンス要件

- 一覧表示: 1秒以内
- 作成/更新: 2秒以内

## セキュリティ考慮事項

- ログインユーザーの従業員データのみアクセス可能（データスコープ制御）
- modifyQueryUsing によるクエリレベルでの制限

## 備考

- 本機能はTimeOffResourceの機能を継承し、ユーザースコープを制限したものです
- MyTimeクラスターに配置され、セルフサービス機能として提供されます
- 管理者機能（承認・却下）は含まれません
