# 機能設計書 95-休暇割当管理

## 概要

本ドキュメントは、休暇管理モジュールにおける休暇割当管理機能の設計仕様を定義します。

### 本機能の処理概要

休暇割当管理機能は、従業員に対する休暇日数の割当を管理するための機能です。管理者・人事担当者が従業員ごとの休暇残日数を設定・管理できます。

**業務上の目的・背景**：
多くの組織では、従業員に年間で一定の休暇日数を付与します。この付与日数は休暇タイプ（有給休暇、慶弔休暇など）ごとに異なり、また従業員の勤続年数や職位によっても変動する場合があります。本機能により、人事担当者は従業員ごとの休暇割当を一元管理し、適切な休暇運用を実現できます。

**機能の利用シーン**：
- 年度初めの休暇日数一括付与
- 新入社員への休暇日数割当
- 休暇タイプ変更時の割当調整
- 割当状況の確認・承認

**主要な処理内容**：
1. 休暇割当の一覧表示・検索・フィルタリング
2. 休暇割当の新規作成
3. 休暇割当の編集・更新
4. 休暇割当の詳細表示
5. 休暇割当の承認・却下
6. 休暇割当の削除

**関連システム・外部連携**：
- 従業員モジュール：従業員情報の参照
- 休暇タイプ管理：休暇種別の参照
- 休暇発生プラン：自動割当との連携

**権限による制御**：
管理者・人事担当者など、適切な権限を持つユーザーのみがアクセス可能です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-TOFF-002 | AllocationResource | 主画面 | 休暇割当の一覧表示・CRUD操作 |
| SCR-TOFF-002 | ListAllocations | 参照画面 | 休暇割当の一覧表示 |
| SCR-TOFF-002 | CreateAllocation | 参照画面 | 休暇割当の新規作成 |
| SCR-TOFF-002 | EditAllocation | 参照画面 | 休暇割当の編集 |
| SCR-TOFF-002 | ViewAllocation | 参照画面 | 休暇割当の詳細表示 |

## 機能種別

CRUD操作 / ワークフロー管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| employee_id | integer | Yes | 従業員ID | 存在する従業員IDであること |
| holiday_status_id | integer | Yes | 休暇タイプID | 存在する休暇タイプIDであること |
| name | string | Yes | 割当名称 | |
| number_of_days | decimal | Yes | 割当日数 | 0以上の数値 |
| allocation_type | enum | No | 割当タイプ | AllocationType Enum値 |
| date_from | date | No | 有効開始日 | 有効な日付 |
| date_to | date | No | 有効終了日 | 開始日以降 |
| accrual_plan_id | integer | No | 休暇発生プランID | 存在するプランIDであること |
| notes | text | No | メモ | |

### 入力データソース

- 画面入力（Filament フォーム）
- AllocationHelper トレイトによるフォーム構築
- 既存マスタデータ（従業員、休暇タイプ、休暇発生プラン）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 割当ID |
| employee.name | string | 従業員名 |
| holidayStatus.name | string | 休暇タイプ名 |
| name | string | 割当名称 |
| number_of_days | decimal | 割当日数 |
| allocation_type | enum | 割当タイプ |
| state | enum | 状態 |
| date_from | date | 有効開始日 |
| date_to | date | 有効終了日 |

### 出力先

- 画面表示（Filament テーブル/フォーム/インフォリスト）
- データベース（time_off_leave_allocations テーブル）

## 処理フロー

### 処理シーケンス

```
1. 一覧表示
   └─ 休暇割当データを取得・表示
2. 新規作成
   └─ フォーム入力 → バリデーション → 状態設定 → 保存
3. 編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. 承認
   └─ 状態を更新 → 通知表示
5. 却下
   └─ 状態を更新 → 通知表示
6. 削除
   └─ レコード削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[一覧画面表示]
    B --> C{操作選択}
    C -->|新規作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|表示| F[詳細画面表示]
    C -->|承認| G[承認処理]
    C -->|却下| H[却下処理]
    C -->|削除| I[削除確認]
    D --> J[バリデーション]
    E --> J
    J -->|成功| K[DB保存]
    J -->|失敗| L[エラー表示]
    G --> M[状態更新]
    H --> N[状態更新]
    I --> O[レコード削除]
    K --> P[成功通知]
    M --> P
    N --> P
    O --> P
    L --> B
    P --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-095-01 | 割当タイプ | allocation_typeで通常割当/発生プラン連動を区別 | 常時 |
| BR-095-02 | 日数計算 | number_of_daysは小数点以下も可（半日単位割当対応） | 常時 |
| BR-095-03 | 有効期間 | date_fromとdate_toで割当の有効期間を制限可能 | 設定時 |
| BR-095-04 | 発生プラン連動 | accrual_plan_id設定時は自動的に日数が加算される | 発生プラン使用時 |

### 計算ロジック

- 繰越日数: expiring_carryover_days で管理
- 年間発生量: yearly_accrued_amount で管理

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | time_off_leave_allocations | SELECT | 休暇割当を取得 |
| 新規作成 | time_off_leave_allocations | INSERT | 休暇割当の新規登録 |
| 編集 | time_off_leave_allocations | UPDATE | 休暇割当の更新 |
| 承認/却下 | time_off_leave_allocations | UPDATE | stateカラムの更新 |
| 削除 | time_off_leave_allocations | DELETE | レコードの削除 |

### テーブル別操作詳細

#### time_off_leave_allocations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | 条件指定 | リレーション含む |
| INSERT | employee_id, holiday_status_id, name, number_of_days, allocation_type, state, 他 | フォーム入力値 | |
| UPDATE | 各カラム | フォーム入力値 | |
| DELETE | - | WHERE id = {record_id} | 削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-095-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-095-02 | 日数エラー | 割当日数が負の値 | 正の数値を入力するよう促す |
| E-095-03 | 期間エラー | 終了日が開始日より前 | 正しい日付を入力するよう促す |

### リトライ仕様

特になし

## トランザクション仕様

- 各CRUD操作は単一トランザクションで実行
- エラー発生時は自動ロールバック

## パフォーマンス要件

- 一覧表示: 1秒以内
- 作成/更新: 2秒以内

## セキュリティ考慮事項

- 管理者・人事担当者権限による制御
- 監査ログ（HasLogActivity トレイト）による操作履歴記録

## 備考

- LeaveAllocationモデルにはHasChatter, HasLogActivityトレイトが適用されています
- allocation_type EnumによりALLOCATION（通常割当）とACCRUAL（発生プラン連動）が区別されます
