# 機能設計書 96-自分の休暇割当管理

## 概要

本ドキュメントは、休暇管理モジュールにおける「自分の休暇割当管理」機能の設計仕様を定義します。

### 本機能の処理概要

自分の休暇割当管理機能は、ログインユーザー自身の休暇割当（残日数）を確認・申請するための機能です。従業員が自分に付与されている休暇日数を確認し、必要に応じて追加割当を申請できます。

**業務上の目的・背景**：
従業員は自身の休暇残日数を把握することで、計画的な休暇取得が可能になります。また、休暇タイプによっては従業員自身が追加割当を申請できる運用もあります。本機能により、従業員は自身の休暇割当状況をセルフサービスで確認・管理できます。

**機能の利用シーン**：
- 自分の休暇残日数の確認
- 追加休暇割当の申請（許可されている休暇タイプの場合）
- 割当申請の履歴確認
- 割当の有効期間確認

**主要な処理内容**：
1. 自分の休暇割当一覧表示（ログインユーザーのみ）
2. 追加割当申請の作成（休暇タイプの設定による）
3. 割当申請の詳細表示
4. 割当申請の編集・削除（申請中のみ）

**関連システム・外部連携**：
- 従業員モジュール：従業員情報（ログインユーザーと紐付く従業員）
- 休暇タイプ管理：休暇種別の参照
- 休暇発生プラン：自動割当との連携

**権限による制御**：
ログインユーザー自身の割当データのみに限定されます。他ユーザーの割当は表示されません。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-TOFF-MY-002 | MyAllocationResource | 主画面 | 自分の休暇割当の一覧表示・CRUD操作 |
| SCR-TOFF-MY-002 | ListMyAllocations | 参照画面 | 自分の休暇割当の一覧表示 |
| SCR-TOFF-MY-002 | CreateMyAllocation | 参照画面 | 休暇割当申請の新規作成 |
| SCR-TOFF-MY-002 | EditMyAllocation | 参照画面 | 休暇割当申請の編集 |
| SCR-TOFF-MY-002 | ViewMyAllocation | 参照画面 | 休暇割当の詳細表示 |

## 機能種別

CRUD操作 / セルフサービス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| holiday_status_id | integer | Yes | 休暇タイプID | 従業員申請可能な休暇タイプであること |
| name | string | Yes | 申請名称 | |
| number_of_days | decimal | Yes | 申請日数 | 0以上の数値 |
| date_from | date | No | 有効開始日 | 有効な日付 |
| date_to | date | No | 有効終了日 | 開始日以降 |
| notes | text | No | メモ・理由 | |

### 入力データソース

- 画面入力（Filament フォーム）
- 認証情報（ログインユーザーの従業員情報）
- 既存マスタデータ（休暇タイプ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 割当ID |
| holidayStatus.name | string | 休暇タイプ名 |
| name | string | 割当名称 |
| number_of_days | decimal | 割当日数 |
| allocation_type | enum | 割当タイプ |
| state | enum | 状態 |
| date_from | date | 有効開始日 |
| date_to | date | 有効終了日 |

### 出力先

- 画面表示（Filament テーブル/フォーム/インフォリスト）
- データベース（time_off_leave_allocations テーブル）

## 処理フロー

### 処理シーケンス

```
1. 一覧表示
   └─ ログインユーザーの従業員IDで割当をフィルタリング取得
2. 新規申請
   └─ 休暇タイプ選択 → 日数入力 → ログインユーザーの従業員ID自動設定 → 保存
3. 編集
   └─ 既存データ取得（所有者・状態チェック）→ フォーム編集 → 保存
4. 削除
   └─ 状態チェック → レコード削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ログインユーザー取得]
    B --> C[従業員ID取得]
    C --> D[一覧画面表示]
    D --> E{操作選択}
    E -->|新規申請| F[作成フォーム表示]
    E -->|編集| G[編集フォーム表示]
    E -->|表示| H[詳細画面表示]
    E -->|削除| I[削除確認]
    F --> J[休暇タイプ選択]
    J --> K{従業員申請可能?}
    K -->|Yes| L[日数入力]
    K -->|No| M[申請不可通知]
    L --> N[バリデーション]
    G --> N
    N -->|成功| O[employee_id自動設定]
    O --> P[DB保存]
    N -->|失敗| Q[エラー表示]
    I --> R{状態チェック}
    R -->|申請中| S[レコード削除]
    R -->|承認済み| T[削除不可通知]
    P --> U[成功通知]
    S --> U
    M --> D
    Q --> D
    T --> D
    U --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-096-01 | ユーザーフィルタ | ログインユーザーの従業員IDに紐づく割当のみ表示 | 常時 |
| BR-096-02 | 従業員自動設定 | employee_idはログインユーザーの従業員IDが自動設定 | 新規作成時 |
| BR-096-03 | 申請可能タイプ | employee_requestsが許可されている休暇タイプのみ申請可能 | 新規作成時 |
| BR-096-04 | 編集可能状態 | 申請中の割当のみ編集可能 | 編集時 |
| BR-096-05 | 削除可能状態 | 承認済みの割当は削除不可 | 削除時 |

### 計算ロジック

- AllocationResourceと同様

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | time_off_leave_allocations | SELECT | ログインユーザーの割当を取得 |
| 新規申請 | time_off_leave_allocations | INSERT | 休暇割当申請の新規登録 |
| 編集 | time_off_leave_allocations | UPDATE | 休暇割当申請の更新 |
| 削除 | time_off_leave_allocations | DELETE | レコードの削除 |

### テーブル別操作詳細

#### time_off_leave_allocations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE employee_id = {current_employee_id} | ログインユーザー限定 |
| INSERT | employee_id, holiday_status_id, name, number_of_days, ... | ログインユーザーの従業員ID + フォーム入力値 | |
| UPDATE | 各カラム | フォーム入力値 | |
| DELETE | - | WHERE id = {record_id} | 削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-096-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-096-02 | 従業員未設定 | ログインユーザーに従業員が紐付いていない | 管理者に連絡を促す |
| E-096-03 | 申請不可エラー | 従業員申請が許可されていない休暇タイプを選択 | 別の休暇タイプを選択するよう促す |
| E-096-04 | 削除不可エラー | 承認済みの割当を削除しようとした | エラーメッセージ表示 |

### リトライ仕様

特になし

## トランザクション仕様

- 各CRUD操作は単一トランザクションで実行
- エラー発生時は自動ロールバック

## パフォーマンス要件

- 一覧表示: 1秒以内
- 作成/更新: 2秒以内

## セキュリティ考慮事項

- ログインユーザーの従業員データのみアクセス可能（データスコープ制御）
- modifyQueryUsing によるクエリレベルでの制限

## 備考

- 本機能はAllocationResourceの機能を継承し、ユーザースコープを制限したものです
- MyTimeクラスターに配置され、セルフサービス機能として提供されます
- 管理者機能（他従業員への割当、承認・却下）は含まれません
- 休暇タイプのemployee_requests設定により、従業員からの割当申請可否が制御されます
