# 機能設計書 97-休暇タイプ管理

## 概要

本ドキュメントは、休暇管理モジュールにおける休暇タイプ管理機能の設計仕様を定義します。

### 本機能の処理概要

休暇タイプ管理機能は、組織で使用する休暇の種類（有給休暇、慶弔休暇、病気休暇など）を定義・管理するための機能です。各休暇タイプに対して承認ルール、割当要件、表示設定などを設定できます。

**業務上の目的・背景**：
組織では様々な種類の休暇制度を運用しています。有給休暇、慶弔休暇、病気休暇、育児休暇など、それぞれ取得条件や承認フロー、日数管理方法が異なります。本機能により、人事担当者は各種休暇タイプを適切に定義し、休暇管理の基盤を整備できます。

**機能の利用シーン**：
- 新しい休暇制度の登録
- 休暇タイプの承認ルール設定
- 割当要件（事前割当必要/不要）の設定
- 休暇タイプの有効/無効切り替え

**主要な処理内容**：
1. 休暇タイプの一覧表示・検索・フィルタリング
2. 休暇タイプの新規作成
3. 休暇タイプの編集・更新
4. 休暇タイプの詳細表示
5. 休暇タイプの削除・復元・完全削除

**関連システム・外部連携**：
- 休暇申請管理：休暇タイプを参照
- 休暇割当管理：休暇タイプを参照
- 休暇発生プラン：休暇タイプと連携

**権限による制御**：
管理者・人事担当者など、設定権限を持つユーザーのみがアクセス可能です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-TOFF-CONFIG-001 | LeaveTypeResource | 主画面 | 休暇タイプの一覧表示・CRUD操作 |
| SCR-TOFF-CONFIG-001 | ListLeaveTypes | 参照画面 | 休暇タイプの一覧表示 |
| SCR-TOFF-CONFIG-001 | CreateLeaveType | 参照画面 | 休暇タイプの新規作成 |
| SCR-TOFF-CONFIG-001 | EditLeaveType | 参照画面 | 休暇タイプの編集 |
| SCR-TOFF-CONFIG-001 | ViewLeaveType | 参照画面 | 休暇タイプの詳細表示 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 休暇タイプ名 | 最大255文字 |
| color | string | Yes | 表示カラー | 16進数カラーコード |
| leave_validation_type | enum | No | 休暇承認タイプ | LeaveValidationType Enum値 |
| requires_allocation | enum | No | 割当必要可否 | RequiresAllocation Enum値 |
| employee_requests | enum | No | 従業員申請可否 | EmployeeRequest Enum値 |
| allocation_validation_type | enum | No | 割当承認タイプ | AllocationValidationType Enum値 |
| request_unit | enum | No | 申請単位 | RequestUnit Enum値 |
| time_type | enum | No | 時間タイプ | TimeType Enum値 |
| include_public_holidays_in_duration | boolean | No | 祝日を含むか | |
| support_document | boolean | No | 証明書類添付可 | |
| show_on_dashboard | boolean | No | ダッシュボード表示 | |
| allows_negative | boolean | No | マイナス残高許可 | |
| max_allowed_negative | integer | No | 最大マイナス日数 | |

### 入力データソース

- 画面入力（Filament フォーム）
- Enum定義（各種オプション）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 休暇タイプID |
| name | string | 休暇タイプ名 |
| color | string | 表示カラー |
| leave_validation_type | enum | 休暇承認タイプ |
| requires_allocation | enum | 割当必要可否 |
| allocation_validation_type | enum | 割当承認タイプ |
| employee_requests | enum | 従業員申請可否 |
| notifiedTimeOffOfficers | relation | 通知先担当者 |
| company.name | string | 会社名 |

### 出力先

- 画面表示（Filament テーブル/フォーム/インフォリスト）
- データベース（time_off_leave_types テーブル）

## 処理フロー

### 処理シーケンス

```
1. 一覧表示
   └─ 休暇タイプデータを取得・表示（並び替え可能）
2. 新規作成
   └─ フォーム入力 → バリデーション → 保存
3. 編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. 削除
   └─ ソフトデリート実行
5. 復元
   └─ ソフトデリート解除
6. 完全削除
   └─ 関連データチェック → 物理削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[一覧画面表示]
    B --> C{操作選択}
    C -->|新規作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|表示| F[詳細画面表示]
    C -->|削除| G[削除確認]
    C -->|復元| H[復元処理]
    C -->|完全削除| I[完全削除確認]
    D --> J[バリデーション]
    E --> J
    J -->|成功| K[DB保存]
    J -->|失敗| L[エラー表示]
    G --> M[ソフトデリート]
    H --> N[復元処理]
    I --> O{関連データチェック}
    O -->|なし| P[物理削除]
    O -->|あり| Q[削除エラー]
    K --> R[成功通知]
    M --> R
    N --> R
    P --> R
    L --> B
    Q --> B
    R --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-097-01 | 承認タイプ | leave_validation_typeで承認フロー（なし/HR/マネージャー/両方）を決定 | 休暇申請時 |
| BR-097-02 | 割当必要 | requires_allocationがYESの場合、事前割当が必要 | 休暇申請時 |
| BR-097-03 | 従業員申請 | requires_allocationがYESの場合のみemployee_requestsが有効 | 設定時 |
| BR-097-04 | マイナス許可 | allows_negativeがtrueの場合、割当残高以上の申請が可能 | 休暇申請時 |
| BR-097-05 | 完全削除制限 | 関連する休暇申請・割当がある場合は完全削除不可 | 完全削除時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | time_off_leave_types | SELECT | 休暇タイプを取得 |
| 新規作成 | time_off_leave_types | INSERT | 休暇タイプの新規登録 |
| 編集 | time_off_leave_types | UPDATE | 休暇タイプの更新 |
| 削除 | time_off_leave_types | UPDATE | deleted_atにタイムスタンプ設定 |
| 復元 | time_off_leave_types | UPDATE | deleted_atをNULLに設定 |
| 完全削除 | time_off_leave_types | DELETE | レコードの物理削除 |
| 通知担当者設定 | time_off_user_leave_types | INSERT/DELETE | 中間テーブル操作 |

### テーブル別操作詳細

#### time_off_leave_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | 条件指定 | ソフトデリート考慮 |
| INSERT | name, color, leave_validation_type, requires_allocation, 他 | フォーム入力値 | |
| UPDATE | 各カラム | フォーム入力値 | |
| UPDATE | deleted_at | CURRENT_TIMESTAMP | ソフトデリート |
| UPDATE | deleted_at | NULL | 復元 |
| DELETE | - | WHERE id = {record_id} | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-097-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-097-02 | 参照整合性エラー | 関連データ存在時の完全削除 | ソフトデリートを推奨 |
| E-097-03 | 色形式エラー | 不正なカラーコード | 正しい形式を入力するよう促す |

### リトライ仕様

特になし

## トランザクション仕様

- 各CRUD操作は単一トランザクションで実行
- 通知担当者設定は中間テーブル操作を含む
- エラー発生時は自動ロールバック

## パフォーマンス要件

- 一覧表示: 1秒以内
- 作成/更新: 2秒以内

## セキュリティ考慮事項

- 設定権限を持つユーザーのみアクセス可能
- ソフトデリートによるデータ保全

## 備考

- LeaveTypeモデルはSortableTraitを実装しており、並び替えが可能です
- SoftDeletesトレイトにより、削除後も復元可能です
- notifiedTimeOffOfficersリレーションにより、休暇申請時の通知先を設定できます
