# 機能設計書 98-休暇発生プラン管理

## 概要

本ドキュメントは、休暇管理モジュールにおける休暇発生プラン管理機能の設計仕様を定義します。

### 本機能の処理概要

休暇発生プラン管理機能は、休暇日数の自動発生（Accrual）ルールを定義・管理するための機能です。勤続期間に応じた段階的な休暇付与や、年間を通じた定期的な休暇発生を設定できます。

**業務上の目的・背景**：
多くの組織では、従業員の勤続年数に応じて休暇日数が増加したり、月ごとに休暇が発生したりする制度を採用しています。これらを手動で管理することは煩雑であり、計算ミスや付与漏れのリスクがあります。本機能により、休暇発生ルールをシステムに設定し、自動的な休暇付与を実現できます。

**機能の利用シーン**：
- 勤続年数に応じた休暇発生プランの設定
- 月次・年次の休暇発生マイルストーン設定
- 繰越日時の設定
- プランの有効/無効切り替え

**主要な処理内容**：
1. 休暇発生プランの一覧表示
2. 休暇発生プランの新規作成
3. 休暇発生プランの編集・更新
4. 休暇発生プランの詳細表示
5. マイルストーン（発生レベル）の管理
6. 休暇発生プランの削除

**関連システム・外部連携**：
- 休暇割当管理：発生プランと連携した自動割当
- 休暇タイプ管理：発生プランで使用する休暇タイプ

**権限による制御**：
管理者・人事担当者など、設定権限を持つユーザーのみがアクセス可能です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-TOFF-CONFIG-002 | AccrualPlanResource | 主画面 | 休暇発生プランの一覧表示・CRUD操作 |
| SCR-TOFF-CONFIG-002 | ListAccrualPlans | 参照画面 | 休暇発生プランの一覧表示 |
| SCR-TOFF-CONFIG-002 | CreateAccrualPlan | 参照画面 | 休暇発生プランの新規作成 |
| SCR-TOFF-CONFIG-002 | EditAccrualPlan | 参照画面 | 休暇発生プランの編集 |
| SCR-TOFF-CONFIG-002 | ViewAccrualPlan | 参照画面 | 休暇発生プランの詳細表示 |
| SCR-TOFF-CONFIG-002 | ManageMilestone | 参照画面 | マイルストーンの管理 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | プラン名 | |
| is_based_on_worked_time | boolean | No | 勤務時間ベース計算 | |
| accrued_gain_time | enum | Yes | 発生タイミング | AccruedGainTime Enum値 |
| carryover_date | enum | Yes | 繰越日タイプ | CarryoverDate Enum値 |
| carryover_day | integer | No | 繰越日（日） | 1-31 |
| carryover_month | enum | No | 繰越月 | CarryoverMonth Enum値 |
| is_active | boolean | No | 有効/無効 | |

### 入力データソース

- 画面入力（Filament フォーム）
- Enum定義（各種オプション）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | プランID |
| name | string | プラン名 |
| is_based_on_worked_time | boolean | 勤務時間ベース |
| accrued_gain_time | enum | 発生タイミング |
| carryover_date | enum | 繰越日タイプ |
| carryover_day | integer | 繰越日 |
| carryover_month | enum | 繰越月 |
| is_active | boolean | 有効/無効 |
| leaveAccrualLevels | relation | マイルストーン一覧 |

### 出力先

- 画面表示（Filament テーブル/フォーム/インフォリスト）
- データベース（time_off_leave_accrual_plans テーブル）

## 処理フロー

### 処理シーケンス

```
1. 一覧表示
   └─ 休暇発生プランデータを取得・表示（レベル数表示）
2. 新規作成
   └─ フォーム入力 → バリデーション → 保存
3. 編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. マイルストーン管理
   └─ 関連するレベル（マイルストーン）の追加・編集・削除
5. 削除
   └─ レコード削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[一覧画面表示]
    B --> C{操作選択}
    C -->|新規作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|表示| F[詳細画面表示]
    C -->|マイルストーン| G[マイルストーン管理画面]
    C -->|削除| H[削除確認]
    D --> I[バリデーション]
    E --> I
    I -->|成功| J[DB保存]
    I -->|失敗| K[エラー表示]
    G --> L[レベル追加/編集/削除]
    H --> M[レコード削除]
    J --> N[成功通知]
    L --> N
    M --> N
    K --> B
    N --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-098-01 | 発生タイミング | accrued_gain_timeで期間開始時/終了時を指定 | 発生計算時 |
| BR-098-02 | 繰越日設定 | carryover_dateがOTHERの場合、carryover_day/monthを指定 | 繰越処理時 |
| BR-098-03 | 勤務時間ベース | is_based_on_worked_timeがtrueの場合、実働時間に比例して発生 | 発生計算時 |
| BR-098-04 | マイルストーン | leaveAccrualLevelsで勤続期間ごとの発生量を段階設定 | 発生計算時 |

### 計算ロジック

- 月次発生: 各月の発生量をマイルストーンに基づいて計算
- 勤務時間ベース: 実働時間÷標準時間×発生量

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | time_off_leave_accrual_plans | SELECT | 発生プランを取得 |
| 新規作成 | time_off_leave_accrual_plans | INSERT | 発生プランの新規登録 |
| 編集 | time_off_leave_accrual_plans | UPDATE | 発生プランの更新 |
| 削除 | time_off_leave_accrual_plans | DELETE | レコードの削除 |
| マイルストーン管理 | time_off_leave_accrual_levels | CRUD | レベルの管理 |

### テーブル別操作詳細

#### time_off_leave_accrual_plans

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | 条件指定 | レベル数含む |
| INSERT | name, is_based_on_worked_time, accrued_gain_time, carryover_date, carryover_day, carryover_month, is_active | フォーム入力値 | |
| UPDATE | 各カラム | フォーム入力値 | |
| DELETE | - | WHERE id = {record_id} | 削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-098-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-098-02 | 日付エラー | 不正な繰越日（月に存在しない日） | 有効な日付を入力するよう促す |
| E-098-03 | 参照エラー | 割当で使用中のプランを削除 | 先に関連割当を解除するよう促す |

### リトライ仕様

特になし

## トランザクション仕様

- 各CRUD操作は単一トランザクションで実行
- マイルストーン操作は関連テーブルを含む
- エラー発生時は自動ロールバック

## パフォーマンス要件

- 一覧表示: 1秒以内
- 作成/更新: 2秒以内

## セキュリティ考慮事項

- 設定権限を持つユーザーのみアクセス可能

## 備考

- LeaveAccrualPlanモデルはleaveAccrualLevelsリレーションを持ち、段階的な発生量を設定できます
- サブナビゲーションでView/Edit/ManageMilestone間を移動できます
- MilestoneRelationManagerでマイルストーンを管理します
