# 機能設計書 99-祝日管理

## 概要

本ドキュメントは、休暇管理モジュールにおける祝日管理機能の設計仕様を定義します。

### 本機能の処理概要

祝日管理機能は、組織で適用される公共の祝日を登録・管理するための機能です。祝日は勤務カレンダーと連携し、休暇日数計算や勤務計画に影響を与えます。

**業務上の目的・背景**：
祝日は休暇日数の計算、勤務カレンダーの設定、給与計算など様々な業務プロセスに影響します。特に休暇申請時に祝日を含む期間を正確に計算するためには、祝日マスタの整備が必要です。本機能により、人事担当者は国や地域の祝日を登録し、適切な労務管理を実現できます。

**機能の利用シーン**：
- 年間祝日の登録
- カレンダー別祝日設定
- 祝日期間（連休）の登録
- 祝日情報の確認・修正

**主要な処理内容**：
1. 祝日の一覧表示・検索・フィルタリング
2. 祝日の新規作成
3. 祝日の編集・更新
4. 祝日の詳細表示
5. 祝日の削除

**関連システム・外部連携**：
- 勤務カレンダー：祝日をカレンダーに反映
- 休暇申請：祝日を含む/含まない計算に使用
- 休暇タイプ：include_public_holidays_in_duration設定と連携

**権限による制御**：
管理者・人事担当者など、設定権限を持つユーザーのみがアクセス可能です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-TOFF-CONFIG-003 | PublicHolidayResource | 主画面 | 祝日の一覧表示・CRUD操作 |
| SCR-TOFF-CONFIG-003 | ListPublicHolidays | 参照画面 | 祝日の一覧表示 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 祝日名 | |
| date_from | date | Yes | 開始日 | 今日以降の日付 |
| date_to | date | Yes | 終了日 | 開始日以降 |
| calendar | integer | No | カレンダーID | 存在するカレンダーIDであること |
| time_type | string | No | 時間タイプ | デフォルト: 'leave' |

### 入力データソース

- 画面入力（Filament フォーム）
- 既存マスタデータ（カレンダー）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 祝日ID |
| name | string | 祝日名 |
| date_from | date | 開始日 |
| date_to | date | 終了日 |
| calendar.name | string | カレンダー名 |
| color | string | 表示カラー |
| company.name | string | 会社名 |

### 出力先

- 画面表示（Filament テーブル/フォーム/インフォリスト）
- データベース（employees_calendar_leaves テーブル）

## 処理フロー

### 処理シーケンス

```
1. 一覧表示
   └─ 祝日データを取得・表示（グループ化可能）
2. 新規作成
   └─ フォーム入力 → バリデーション → 保存
3. 編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. 削除
   └─ レコード削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[一覧画面表示]
    B --> C{操作選択}
    C -->|新規作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|表示| F[詳細画面表示]
    C -->|削除| G[削除確認]
    D --> H[日付入力]
    H --> I{開始日 <= 終了日?}
    I -->|Yes| J[バリデーション]
    I -->|No| K[日付エラー表示]
    E --> J
    J -->|成功| L[DB保存]
    J -->|失敗| M[エラー表示]
    G --> N[レコード削除]
    L --> O[成功通知]
    N --> O
    K --> D
    M --> B
    O --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-099-01 | 日付制限 | date_fromは今日以降である必要がある | 新規作成時 |
| BR-099-02 | 期間整合性 | date_toはdate_from以降である必要がある | 常時 |
| BR-099-03 | カレンダー連携 | calendarを指定すると、そのカレンダーのみに適用される | 設定時 |
| BR-099-04 | time_type | 'leave'として登録され、休日として扱われる | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | employees_calendar_leaves | SELECT | 祝日を取得 |
| 新規作成 | employees_calendar_leaves | INSERT | 祝日の新規登録 |
| 編集 | employees_calendar_leaves | UPDATE | 祝日の更新 |
| 削除 | employees_calendar_leaves | DELETE | レコードの削除 |

### テーブル別操作詳細

#### employees_calendar_leaves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | 条件指定 | カレンダーリレーション含む |
| INSERT | name, date_from, date_to, calendar_id, time_type | フォーム入力値 | time_type='leave' |
| UPDATE | name, date_from, date_to, calendar_id | フォーム入力値 | |
| DELETE | - | WHERE id = {record_id} | 削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-099-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-099-02 | 日付エラー | 開始日が今日より前 | 今日以降の日付を入力するよう促す |
| E-099-03 | 期間エラー | 終了日が開始日より前 | 正しい期間を入力するよう促す |

### リトライ仕様

特になし

## トランザクション仕様

- 各CRUD操作は単一トランザクションで実行
- エラー発生時は自動ロールバック

## パフォーマンス要件

- 一覧表示: 1秒以内
- 作成/更新: 2秒以内

## セキュリティ考慮事項

- 設定権限を持つユーザーのみアクセス可能

## 備考

- CalendarLeaveモデルは従業員モジュールのBaseCalendarLeaveを継承しています
- 祝日はテーブルのグループ機能で開始日、終了日、会社名でグループ化できます
- time_typeフィールドは'leave'として自動設定されます
