---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート: プラグイン管理機能設計書

## 1. 概要

本レポートは「プラグイン管理」機能設計書の各記述について、ソースコードからの根拠を示すものである。

## 2. 根拠一覧

### 2.1 機能概要の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| プラグイン一覧表示機能 | plugins/webkul/plugin-manager/src/Filament/Resources/PluginResource.php | `class PluginResource extends Resource` | 高 |
| プラグイン有効化/無効化機能 | plugins/webkul/plugin-manager/src/Filament/Resources/PluginResource.php | テーブルカラムにトグル実装 | 高 |
| 管理画面実装 | plugins/webkul/plugin-manager/src/Filament/Resources/PluginResource/Pages/ListPlugins.php | ListRecordsを継承 | 高 |

### 2.2 データ構造の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| pluginsテーブル定義 | plugins/webkul/support/database/migrations/2024_11_05_105102_create_plugins_table.php | マイグレーションファイル | 高 |
| is_activeカラム | 同上 | `$table->boolean('is_active')->default(true)` | 高 |
| nameカラム | 同上 | `$table->string('name')` | 高 |

### 2.3 クラス構成の根拠

| 記述内容 | 根拠ファイル | 確認方法 | 信頼度 |
|----------|--------------|----------|--------|
| PluginResource | plugins/webkul/plugin-manager/src/Filament/Resources/PluginResource.php | ファイル存在確認 | 高 |
| ListPlugins | plugins/webkul/plugin-manager/src/Filament/Resources/PluginResource/Pages/ListPlugins.php | ファイル存在確認 | 高 |
| PluginManagerPlugin | plugins/webkul/plugin-manager/src/PluginManagerPlugin.php | ファイル存在確認 | 高 |
| Package | plugins/webkul/support/src/Package.php | ファイル存在確認 | 高 |

### 2.4 依存関係の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| Filament依存 | plugins/webkul/plugin-manager/src/Filament/Resources/PluginResource.php | `use Filament\Resources\Resource` | 高 |
| Support依存 | plugins/webkul/plugin-manager/src/PluginManagerPlugin.php | 名前空間とuse文 | 高 |

## 3. 根拠のない記述

| 記述内容 | 理由 | 推奨対応 |
|----------|------|----------|
| 依存関係チェック（BR-002） | 実装コード未確認 | 実装有無の確認が必要 |
| コアプラグイン保護（BR-003） | 実装コード未確認 | 実装有無の確認が必要 |

## 4. ソースコード参照

### PluginResource.php（主要部分）
```php
// plugins/webkul/plugin-manager/src/Filament/Resources/PluginResource.php
class PluginResource extends Resource
{
    protected static ?string $model = Plugin::class;
    protected static ?string $slug = 'plugins';
    protected static ?string $navigationIcon = 'heroicon-o-puzzle-piece';
}
```

### マイグレーション（plugins テーブル）
```php
// plugins/webkul/support/database/migrations/2024_11_05_105102_create_plugins_table.php
Schema::create('plugins', function (Blueprint $table) {
    $table->id();
    $table->string('name');
    $table->boolean('is_active')->default(true);
    $table->timestamps();
});
```

## 5. 信頼度評価

- **高信頼度（16件）**: ソースコードから直接確認できる記述
- **低信頼度（2件）**: ビジネスルールの一部で実装確認が必要

**総合信頼度: 89%**
