---
generated_at: 2025-12-26 12:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: フルカレンダー機能設計書

## 1. 概要

本レポートは「フルカレンダー」機能設計書の各記述について、ソースコードからの根拠を示すものである。

## 2. 根拠一覧

### 2.1 機能概要の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| FullCalendarWidget基底クラス | plugins/webkul/full-calendar/src/Filament/Widgets/FullCalendarWidget.php | `class FullCalendarWidget extends Widget` | 高 |
| インターフェース実装 | 同上 | `implements HasActions, HasConfigurations, HasEvents, HasForms, HasHeaderActions, HasModalActions, HasRawJs, HasRecords` | 高 |
| フルスパン表示 | 同上 | `protected int|string|array $columnSpan = 'full'` | 高 |

### 2.2 トレイト使用の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| CanBeConfigured | FullCalendarWidget.php | `use CanBeConfigured` | 高 |
| InteractsWithActions | 同上 | `use InteractsWithActions` | 高 |
| InteractsWithEvents | 同上 | `use InteractsWithEvents` | 高 |
| InteractsWithForms | 同上 | `use InteractsWithForms` | 高 |
| InteractsWithHeaderActions | 同上 | `use InteractsWithHeaderActions` | 高 |
| InteractsWithModalActions | 同上 | `use InteractsWithModalActions` | 高 |
| InteractsWithRawJS | 同上 | `use InteractsWithRawJS` | 高 |
| InteractsWithRecord | 同上 | `use InteractsWithRecord` | 高 |

### 2.3 アクション機能の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| ヘッダーアクション | FullCalendarWidget.php | `protected function headerActions(): array` | 高 |
| CreateAction | 同上 | `return [CreateAction::make()]` | 高 |
| モーダルアクション | 同上 | `protected function modalActions(): array` | 高 |
| EditAction | 同上 | `EditAction::make()` | 高 |
| DeleteAction | 同上 | `DeleteAction::make()` | 高 |
| ViewAction | 同上 | `protected function viewAction(): Action` | 高 |

### 2.4 イベント・フォーム機能の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| fetchEventsメソッド | FullCalendarWidget.php | `public function fetchEvents(array $info): array` | 高 |
| getFormSchemaメソッド | 同上 | `public function getFormSchema(): array` | 高 |
| ビューテンプレート | 同上 | `protected string $view = 'full-calendar::filament.widgets.full-calendar'` | 高 |

## 3. ソースコード参照

### FullCalendarWidget.php
```php
// plugins/webkul/full-calendar/src/Filament/Widgets/FullCalendarWidget.php
namespace Webkul\FullCalendar\Filament\Widgets;

use Filament\Actions\Action;
use Filament\Actions\Concerns\InteractsWithActions;
use Filament\Actions\Contracts\HasActions;
use Filament\Actions\CreateAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Widgets\Widget;
use Webkul\FullCalendar\Concerns\CanBeConfigured;
use Webkul\FullCalendar\Concerns\InteractsWithEvents;
use Webkul\FullCalendar\Concerns\InteractsWithHeaderActions;
use Webkul\FullCalendar\Concerns\InteractsWithModalActions;
use Webkul\FullCalendar\Concerns\InteractsWithRawJS;
use Webkul\FullCalendar\Concerns\InteractsWithRecord;
use Webkul\FullCalendar\Contracts\HasConfigurations;
use Webkul\FullCalendar\Contracts\HasEvents;
use Webkul\FullCalendar\Contracts\HasHeaderActions;
use Webkul\FullCalendar\Contracts\HasModalActions;
use Webkul\FullCalendar\Contracts\HasRawJs;
use Webkul\FullCalendar\Contracts\HasRecords;

class FullCalendarWidget extends Widget implements HasActions, HasConfigurations, HasEvents, HasForms, HasHeaderActions, HasModalActions, HasRawJs, HasRecords
{
    use CanBeConfigured;
    use InteractsWithActions;
    use InteractsWithEvents;
    use InteractsWithForms;
    use InteractsWithHeaderActions;
    use InteractsWithModalActions;
    use InteractsWithRawJS;
    use InteractsWithRecord;

    protected string $view = 'full-calendar::filament.widgets.full-calendar';

    protected int|string|array $columnSpan = 'full';

    protected function headerActions(): array
    {
        return [
            CreateAction::make(),
        ];
    }

    protected function modalActions(): array
    {
        return [
            EditAction::make(),
            DeleteAction::make(),
        ];
    }

    protected function viewAction(): Action
    {
        return ViewAction::make();
    }

    public function fetchEvents(array $info): array
    {
        return [];
    }

    public function getFormSchema(): array
    {
        return [];
    }
}
```

## 4. 根拠のない記述

なし - 全ての記述がソースコードから確認できる。

## 5. 信頼度評価

- **高信頼度（18件）**: ソースコードから直接確認できる記述

**総合信頼度: 100%**

## 6. 補足事項

FullCalendarWidgetは抽象的な基底クラスとして設計されており、各モジュール（プロジェクト、HR等）で継承して具体的な実装を行う。fetchEventsとgetFormSchemaはデフォルトで空配列を返し、継承先でオーバーライドする設計となっている。
