---
generated_at: 2025-12-26 23:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：100-必須休暇日管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的数値の根拠不足
  2. **休暇申請との連携**：詳細実装を要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/MandatoryDayResource.php`
- E-02: `plugins/webkul/time-off/src/Models/LeaveMandatoryDay.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MandatoryDayResourceはResourceを継承 | E-01 L29 | ○ |
| C-02 | モデルはLeaveMandatoryDay::class | E-01 L31 | ○ |
| C-03 | クラスターはConfigurations | E-01 L35 | ○ |
| C-04 | フォームにcolor, name, start_date, end_date | E-01 L49-71 | ○ |
| C-05 | colorのデフォルト値は#000000 | E-01 L53-57 | ○ |
| C-06 | start_dateとend_dateのデフォルトは今日 | E-01 L61-69 | ○ |
| C-07 | テーブルカラム: name, company.name, createdBy.name, start_date, end_date | E-01 L74-99 | ○ |
| C-08 | フィルター: company_id, creator_id, QueryBuilder | E-01 L101-128 | ○ |
| C-09 | グループ: name, createdBy.name, company.name, start_date, end_date | E-01 L130-145 | ○ |
| C-10 | アクション: View, Edit, Delete | E-01 L147-162 | ○ |
| C-11 | ページ: index | E-01 L200-203 | ○ |
| C-12 | LeaveMandatoryDayモデルのテーブルはtime_off_leave_mandatory_days | E-02 L14 | ○ |
| C-13 | fillable項目: company_id, creator_id, color, name, start_date, end_date | E-02 L16-23 | ○ |
| C-14 | 機能IDはF100 | E-03 L101 | ○ |
| C-15 | パフォーマンス要件: 一覧1秒 | **根拠なし** | △ |
| C-16 | 休暇申請との連携詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は設計書として推測で記載
  - 候補：負荷テスト結果 / 非機能要件定義書 / SLA定義書
- 休暇申請との連携（必須休暇日の重複チェック等）
  - 候補：TimeOffHelper.php / 休暇日数計算サービス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は十分なコード根拠あり
- 1: 中リスク - 必須休暇日の活用方法を要確認

## 6) レビュアーチェックリスト（最小）
- [ ] LeaveMandatoryDayモデルの構造を確認
- [ ] カラーピッカーの動作を確認
- [ ] グループ・フィルター機能の動作を確認
- [ ] 必須休暇日がカレンダーに反映されるか確認
