---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：101-活動タイプ管理(休暇)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な要件定義なし
  2. **エラーコード体系**：推定値のため確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/ActivityTypeResource.php`
- E-02: `plugins/webkul/support/src/Filament/Resources/ActivityTypeResource.php`
- E-03: `plugins/webkul/time-off/src/Models/ActivityType.php`
- E-04: `plugins/webkul/support/src/Models/ActivityType.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` (F101)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ActivityTypeResourceがBaseActivityTypeResourceを継承 | E-01 | ○ |
| C-02 | モデルはWebkul\TimeOff\Models\ActivityType | E-01 | ○ |
| C-03 | プラグイン名は'time-off' | E-01 | ○ |
| C-04 | ナビゲーションソート順は5 | E-01 | ○ |
| C-05 | CRUD操作(作成・編集・表示・削除)対応 | E-01, E-02 | ○ |
| C-06 | nameフィールドは必須で最大255文字 | E-02 | ○ |
| C-07 | delay_countはデフォルト0、数値型 | E-02 | ○ |
| C-08 | delay_unitはデフォルトMINUTES | E-02 | ○ |
| C-09 | delay_fromはデフォルトPREVIOUS_ACTIVITY | E-02 | ○ |
| C-10 | chaining_typeはデフォルトSUGGEST | E-02 | ○ |
| C-11 | pluginフィールドでtime-offをフィルタ | E-02 | ○ |
| C-12 | ソフトデリート対応 | E-02 | ○ |
| C-13 | ドラッグ&ドロップで並び替え可能(reorderable) | E-02 | ○ |
| C-14 | グループ化機能対応 | E-02 | ○ |
| C-15 | ActivityTypePolicyによる権限制御 | E-03 | ○ |
| C-16 | フォームでIconPickerを使用 | E-02 | ○ |
| C-17 | パフォーマンス要件(2秒/1秒) | **根拠なし** | △ |
| C-18 | エラーコード体系(E-101-01等) | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件：コードから具体的な要件定義を見つけられなかった
  - 候補：非機能要件定義書 / SLA定義 / 性能テスト仕様書
- エラーコード体系：独自に設計したものであり、既存定義なし
  - 候補：エラーコード規約 / システム設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件は実際のシステム要件と一致しているか確認
- [ ] エラーコード体系が他ドキュメントと整合しているか確認
- [ ] 権限制御の詳細仕様を確認
