---
generated_at: 2025-12-26 12:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：102-タイムシート管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な要件定義なし
  2. **エラーコード体系**：推定値のため確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/timesheets/src/Filament/Resources/TimesheetResource.php`
- E-02: `plugins/webkul/projects/src/Models/Timesheet.php`
- E-03: `plugins/webkul/projects/src/Filament/Resources/TaskResource/RelationManagers/TimesheetsRelationManager.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` (F102)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Timesheetモデルを使用 | E-01 | ○ |
| C-02 | typeフィールドに'projects'固定値 | E-01 | ○ |
| C-03 | dateフィールドは必須、DatePicker | E-01 | ○ |
| C-04 | user_idは必須、リレーション設定 | E-01 | ○ |
| C-05 | project_idは必須、liveで動作 | E-01 | ○ |
| C-06 | task_idはproject_idでフィルタ | E-01 | ○ |
| C-07 | unit_amountは数値、0以上 | E-01 | ○ |
| C-08 | unit_amountの最大値は99999999999 | E-01 | ○ |
| C-09 | 時間表示は時:分形式 | E-01, E-03 | ○ |
| C-10 | Sumで集計機能あり | E-01, E-03 | ○ |
| C-11 | 日付範囲フィルタ対応 | E-01 | ○ |
| C-12 | プロジェクト/タスク/従業員フィルタ | E-01 | ○ |
| C-13 | グループ化機能(日付/従業員/プロジェクト/タスク) | E-01 | ○ |
| C-14 | タイムシートCUD時にタスク工数自動更新 | E-02 | ○ |
| C-15 | effective_hours計算ロジック | E-02 | ○ |
| C-16 | total_hours_spent計算ロジック | E-02 | ○ |
| C-17 | remaining_hours計算ロジック | E-02 | ○ |
| C-18 | progress計算ロジック | E-02 | ○ |
| C-19 | パフォーマンス要件(2秒/1秒) | **根拠なし** | △ |
| C-20 | エラーコード体系(E-102-xx) | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件：コードから具体的な要件定義を見つけられなかった
  - 候補：非機能要件定義書 / SLA定義 / 性能テスト仕様書
- エラーコード体系：独自に設計したものであり、既存定義なし
  - 候補：エラーコード規約 / システム設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - タスク工数の自動更新ロジックは正確に反映されている

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件は実際のシステム要件と一致しているか確認
- [ ] エラーコード体系が他ドキュメントと整合しているか確認
- [ ] タスク工数の計算ロジックが業務要件と一致しているか確認
- [ ] サブタスクを含む工数計算が正しいか確認
