---
generated_at: 2025-12-26 12:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：104-タスク管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な要件定義なし
  2. **エラーコード体系**：推定値のため確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/projects/src/Filament/Resources/TaskResource.php`
- E-02: `plugins/webkul/projects/src/Models/Task.php`
- E-03: `plugins/webkul/projects/src/Enums/TaskState.php`
- E-04: `plugins/webkul/projects/src/Models/Timesheet.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` (F104)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Taskモデルを使用 | E-01 | ○ |
| C-02 | titleフィールドは必須で最大255文字 | E-01 | ○ |
| C-03 | ProgressStepperでステージ管理 | E-01 | ○ |
| C-04 | stateはTaskState Enumで管理 | E-01, E-03 | ○ |
| C-05 | stateのデフォルトはIN_PROGRESS | E-01 | ○ |
| C-06 | priorityはトグル可能 | E-01 | ○ |
| C-07 | 状態変更はモーダルで実行 | E-01 | ○ |
| C-08 | プロジェクト変更時にマイルストーンをリセット | E-01 | ○ |
| C-09 | プロジェクトの顧客を引継ぎ | E-01 | ○ |
| C-10 | マイルストーンはenable_milestones時のみ表示 | E-01 | ○ |
| C-11 | allocated_hoursはenable_timesheets時のみ表示 | E-01 | ○ |
| C-12 | allocated_hoursの最大値は99999999999 | E-01 | ○ |
| C-13 | 担当者は複数選択可能(users) | E-01 | ○ |
| C-14 | QueryBuilderによる高度なフィルタ | E-01 | ○ |
| C-15 | グループ化機能(state/project/deadline/stage/milestone等) | E-01 | ○ |
| C-16 | ドラッグ&ドロップ並び替え(reorderable) | E-01, E-02 | ○ |
| C-17 | SoftDeletes対応 | E-02 | ○ |
| C-18 | タスク更新時にタイムシートも自動更新 | E-02 | ○ |
| C-19 | タイムシートCUD時にタスク工数自動更新 | E-04 | ○ |
| C-20 | effective_hours計算ロジック | E-04 | ○ |
| C-21 | progress計算ロジック | E-04 | ○ |
| C-22 | UserPermissionScope('users')によるアクセス制御 | E-02 | ○ |
| C-23 | HasCustomFieldsトレイト対応 | E-01, E-02 | ○ |
| C-24 | HasChatter, HasLogActivityトレイト対応 | E-02 | ○ |
| C-25 | グローバル検索対応 | E-01 | ○ |
| C-26 | サブナビゲーション(View/Edit/Timesheets/SubTasks) | E-01 | ○ |
| C-27 | パフォーマンス要件(2秒/1秒) | **根拠なし** | △ |
| C-28 | エラーコード体系(E-104-xx) | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件：コードから具体的な要件定義を見つけられなかった
  - 候補：非機能要件定義書 / SLA定義 / 性能テスト仕様書
- エラーコード体系：独自に設計したものであり、既存定義なし
  - 候補：エラーコード規約 / システム設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件は実際のシステム要件と一致しているか確認
- [ ] エラーコード体系が他ドキュメントと整合しているか確認
- [ ] TaskState Enumの値が正しいか確認
- [ ] タイムシート連動の工数計算が正しいか確認
