---
generated_at: 2025-12-26 12:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：105-マイルストーン管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な要件定義なし
  2. **エラーコード体系**：推定値のため確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/projects/src/Filament/Clusters/Configurations/Resources/MilestoneResource.php`
- E-02: `plugins/webkul/projects/src/Filament/Resources/ProjectResource/RelationManagers/MilestonesRelationManager.php`
- E-03: `plugins/webkul/projects/src/Models/Milestone.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` (F105)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Milestoneモデルを使用 | E-01 | ○ |
| C-02 | nameフィールドは必須で最大255文字 | E-01 | ○ |
| C-03 | is_completedは必須 | E-01 | ○ |
| C-04 | TaskSettings.enable_milestonesで表示制御 | E-01 | ○ |
| C-05 | project.allow_milestonesで表示制御 | E-02 | ○ |
| C-06 | ToggleColumnで完了状態即時変更 | E-01 | ○ |
| C-07 | is_completed変更時にcompleted_at自動設定 | E-01 | ○ |
| C-08 | creator_id自動設定 | E-02 | ○ |
| C-09 | RelationManager時にproject_id非表示 | E-01 | ○ |
| C-10 | reorderableColumns対応 | E-01 | ○ |
| C-11 | グループ化機能(project/is_completed/created_at) | E-01 | ○ |
| C-12 | Configurations Clusterに配置 | E-01 | ○ |
| C-13 | ナビゲーションソート順は3 | E-01 | ○ |
| C-14 | 物理削除 | E-01 | ○ |
| C-15 | パフォーマンス要件(2秒/1秒) | **根拠なし** | △ |
| C-16 | エラーコード体系(E-105-xx) | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件：コードから具体的な要件定義を見つけられなかった
- エラーコード体系：独自に設計したものであり、既存定義なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件は実際のシステム要件と一致しているか確認
- [ ] エラーコード体系が他ドキュメントと整合しているか確認
- [ ] completed_atの自動設定ロジックが正しいか確認
