---
generated_at: 2025-12-26 12:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：106-タスクステージ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な要件定義なし
  2. **エラーコード体系**：推定値のため確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/projects/src/Filament/Clusters/Configurations/Resources/TaskStageResource.php`
- E-02: `plugins/webkul/projects/src/Filament/Resources/ProjectResource/RelationManagers/TaskStagesRelationManager.php`
- E-03: `plugins/webkul/projects/src/Models/TaskStage.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` (F106)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TaskStageモデルを使用 | E-01 | ○ |
| C-02 | nameフィールドは必須で最大255文字 | E-01 | ○ |
| C-03 | project_idはwithTrashedで削除済みも表示 | E-01 | ○ |
| C-04 | 削除済みプロジェクトは選択不可 | E-01 | ○ |
| C-05 | SoftDeletes対応 | E-01 | ○ |
| C-06 | 関連タスク存在時は完全削除不可 | E-01 | ○ |
| C-07 | QueryException捕捉でエラーハンドリング | E-01 | ○ |
| C-08 | RelationManager時にproject_id非表示 | E-01 | ○ |
| C-09 | reorderable('sort')対応 | E-01 | ○ |
| C-10 | デフォルトソートはsort降順 | E-01 | ○ |
| C-11 | グループ化機能(project/created_at) | E-01 | ○ |
| C-12 | Configurations Clusterに配置 | E-01 | ○ |
| C-13 | ナビゲーションソート順は2 | E-01 | ○ |
| C-14 | 一括復元/削除/完全削除対応 | E-01 | ○ |
| C-15 | パフォーマンス要件(2秒/1秒) | **根拠なし** | △ |
| C-16 | エラーコード体系(E-106-xx) | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件：コードから具体的な要件定義を見つけられなかった
- エラーコード体系：独自に設計したものであり、既存定義なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件は実際のシステム要件と一致しているか確認
- [ ] エラーコード体系が他ドキュメントと整合しているか確認
- [ ] 外部キー制約によるエラーハンドリングが適切か確認
