---
generated_at: 2025-12-26 12:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：107-サブタスク管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な要件定義なし
  2. **エラーコード体系**：推定値のため確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/projects/src/Filament/Resources/TaskResource/RelationManagers/SubTasksRelationManager.php`
- E-02: `plugins/webkul/projects/src/Models/Task.php`
- E-03: `plugins/webkul/projects/src/Models/Timesheet.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` (F107)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SubTasksRelationManagerとして実装 | E-01 | ○ |
| C-02 | titleフィールドは必須 | E-01 | ○ |
| C-03 | stateはTaskState Enumで管理 | E-01 | ○ |
| C-04 | stateのデフォルトはIN_PROGRESS | E-01 | ○ |
| C-05 | parent_idで親子関係を表現 | E-01 | ○ |
| C-06 | 親タスクからproject_id継承 | E-01 | ○ |
| C-07 | サブタスク工数は親タスクに集計 | E-03 | ○ |
| C-08 | subtask_effective_hours計算ロジック | E-03 | ○ |
| C-09 | ProgressBarEntryで進捗表示 | E-01 | ○ |
| C-10 | 進捗率色分け(danger/warning/success) | E-01 | ○ |
| C-11 | サブタスク詳細はTaskResource画面へ遷移 | E-01 | ○ |
| C-12 | SoftDeletes対応 | E-02 | ○ |
| C-13 | グループ化機能(state/stage/created_at) | E-01 | ○ |
| C-14 | reorderable対応 | E-01 | ○ |
| C-15 | パフォーマンス要件(2秒/1秒) | **根拠なし** | △ |
| C-16 | エラーコード体系(E-107-xx) | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件：コードから具体的な要件定義を見つけられなかった
- エラーコード体系：独自に設計したものであり、既存定義なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件は実際のシステム要件と一致しているか確認
- [ ] エラーコード体系が他ドキュメントと整合しているか確認
- [ ] 親タスクへの工数集計ロジックが正しいか確認
