---
generated_at: 2025-12-26 12:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：108-タスク工数管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な要件定義なし
  2. **エラーコード体系**：推定値のため確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/projects/src/Filament/Resources/TaskResource/RelationManagers/TimesheetsRelationManager.php`
- E-02: `plugins/webkul/projects/src/Models/Timesheet.php`
- E-03: `plugins/webkul/projects/src/Models/Task.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` (F108)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TimesheetsRelationManagerとして実装 | E-01 | ○ |
| C-02 | dateフィールドは必須 | E-01 | ○ |
| C-03 | user_idフィールドは必須 | E-01 | ○ |
| C-04 | unit_amountフィールドは必須 | E-01 | ○ |
| C-05 | 時間表示は時:分形式 | E-01 | ○ |
| C-06 | Sum::make()で合計表示 | E-01 | ○ |
| C-07 | タイムシートCUD時にタスク工数自動更新 | E-02 | ○ |
| C-08 | effective_hours計算ロジック | E-02 | ○ |
| C-09 | total_hours_spent計算ロジック | E-02 | ○ |
| C-10 | remaining_hours計算ロジック | E-02 | ○ |
| C-11 | progress計算ロジック | E-02 | ○ |
| C-12 | subtask_effective_hours計算ロジック | E-02 | ○ |
| C-13 | 親タスク連動更新 | E-02 | ○ |
| C-14 | グループ化機能(date/user/created_at) | E-01 | ○ |
| C-15 | TimeSettings.enable_timesheetsで表示制御 | E-01 | ○ |
| C-16 | reorderable対応 | E-01 | ○ |
| C-17 | パフォーマンス要件(2秒/1秒) | **根拠なし** | △ |
| C-18 | エラーコード体系(E-108-xx) | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件：コードから具体的な要件定義を見つけられなかった
- エラーコード体系：独自に設計したものであり、既存定義なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 工数計算ロジックは詳細に検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件は実際のシステム要件と一致しているか確認
- [ ] エラーコード体系が他ドキュメントと整合しているか確認
- [ ] 工数計算ロジックが業務要件と一致しているか確認
- [ ] サブタスクを含む階層的工数集計が正しいか確認
