---
generated_at: 2025-12-26 23:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 25
  claims_without_evidence: 3
confidence_derived: 0.89
---

# 根拠レポート：F011-サポート機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：25 / 28、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠が不明
  2. **権限制御の詳細**：PolicyファイルはあるがUIレベルの制御詳細が未確認
  3. **メールログ機能**：モデルは存在するがUIリソースが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/support/src/SupportPlugin.php`
- E-02: `plugins/webkul/support/src/Models/ActivityType.php`
- E-03: `plugins/webkul/support/src/Filament/Resources/ActivityTypeResource.php`
- E-04: `plugins/webkul/support/database/migrations/2024_12_12_115256_create_activity_types_table.php`
- E-05: `plugins/webkul/support/database/seeders/ActivityTypeSeeder.php`
- E-06: `plugins/webkul/support/src/Enums/ActivityTypeAction.php`
- E-07: `plugins/webkul/support/src/Enums/ActivityDelayUnit.php`
- E-08: `plugins/webkul/support/src/Enums/ActivityDelayFrom.php`
- E-09: `plugins/webkul/support/src/Enums/ActivityChainingType.php`
- E-10: `plugins/webkul/support/src/Policies/ActivityTypePolicy.php`
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サポートプラグインはsupportとして実装されている | E-01 | ○ |
| C-02 | 活動タイプはActivityTypeモデルで管理 | E-02 | ○ |
| C-03 | ActivityTypeResourceでCRUD操作を提供 | E-03 | ○ |
| C-04 | activity_typesテーブルが存在 | E-04 | ○ |
| C-05 | nameは必須フィールド | E-03 (TextInput::make('name')->required()) | ○ |
| C-06 | delay_countのデフォルト値は0 | E-03 (->default(0)) | ○ |
| C-07 | delay_unitはActivityDelayUnit Enumを使用 | E-03, E-07 | ○ |
| C-08 | chaining_typeのデフォルトはsuggest | E-03 (->default(ActivityChainingType::SUGGEST->value)) | ○ |
| C-09 | ソフトデリート対応 | E-02 (use SoftDeletes) | ○ |
| C-10 | plugin別フィルタ機能 | E-03 (modifyQueryUsing fn ($query) => $query->where('plugin', static::$pluginName)) | ○ |
| C-11 | sortカラムによる並び替え | E-02 (use SortableTrait), E-03 (->reorderable('sort')) | ○ |
| C-12 | 活動プラン連携 | E-02 (activityPlan relation) | ○ |
| C-13 | サジェスト活動タイプの多対多関係 | E-02 (suggestedActivityTypes BelongsToMany) | ○ |
| C-14 | トリガー次タイプの設定 | E-02 (triggeredNextType BelongsTo) | ○ |
| C-15 | アイコンピッカー使用 | E-03 (IconPicker::make('icon')) | ○ |
| C-16 | heroicons/fontawesome-solid対応 | E-03 (->sets(['heroicons', 'fontawesome-solid'])) | ○ |
| C-17 | is_activeとkeep_doneのトグル | E-03 (Toggle::make) | ○ |
| C-18 | 削除・復元アクション | E-03 (DeleteAction, RestoreAction, ForceDeleteAction) | ○ |
| C-19 | 一括削除・復元対応 | E-03 (DeleteBulkAction, RestoreBulkAction) | ○ |
| C-20 | ActivityTypePolicyによるアクセス制御 | E-10 | ○ |
| C-21 | グループ化機能 | E-03 (Groups section) | ○ |
| C-22 | フィルター機能 | E-03 (SelectFilter, TernaryFilter, Filter) | ○ |
| C-23 | 初期データシーダー | E-05 | ○ |
| C-24 | 機能一覧.csvに記載あり | E-11 (F011) | ○ |
| C-25 | 画面機能マッピングに記載あり | E-12 (SCR-SUP-001) | ○ |
| C-26 | パフォーマンス要件1秒以内 | **根拠なし** | △ |
| C-27 | 権限によるUI制御詳細 | **根拠不足** | △ |
| C-28 | メールログ機能のUI | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値根拠
  - 候補：性能テスト結果 / 要件定義書 / SLA文書
- メールログ・メールテンプレート機能のUI実装
  - 候補：EmailLogResource / EmailTemplateResource（現状未発見）
- 権限制御のUI表示レベルでの詳細仕様
  - 候補：各ページでのcan()チェック実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の設計内容は根拠あり
- 1: 中リスク - パフォーマンス要件は実測が必要
- 0: 低リスク - セキュリティ考慮事項はLaravel標準機能で対応

## 6) レビュアーチェックリスト（最小）
- [ ] 活動タイプのフィールド定義がマイグレーションと一致しているか確認
- [ ] ActivityTypePolicyの権限定義を確認
- [ ] パフォーマンス要件の妥当性を検討
- [ ] 他プラグインからの活動タイプ参照パターンを確認
