---
generated_at: 2025-12-26 23:19:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：113-ウェブサイトパートナー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/website/src/Filament/Admin/Resources/PartnerResource.php`
- E-02: `plugins/webkul/website/src/Models/Partner.php`
- E-03: `plugins/webkul/partners/src/Models/Partner.php`
- E-04: `plugins/webkul/partners/database/migrations/2024_12_11_101220_create_partners_partners_table.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PartnerResourceでパートナーCRUD管理を行う | E-01 | ○ |
| C-02 | Website PartnerモデルがBasePartnerを継承 | E-02 | ○ |
| C-03 | partners_partnersテーブルを使用 | E-03, E-04 | ○ |
| C-04 | password項目がハッシュ化される | E-02 | ○ |
| C-05 | is_active項目が存在 | E-02 | ○ |
| C-06 | password項目が$hiddenに設定 | E-02 | ○ |
| C-07 | SoftDeletesトレイトによるソフトデリート対応 | E-03 | ○ |
| C-08 | FilamentUserインターフェース実装 | E-03 | ○ |
| C-09 | Authenticatableを継承 | E-03 | ○ |
| C-10 | Notifiableトレイト使用 | E-03 | ○ |
| C-11 | HasChatter, HasLogActivityトレイト使用 | E-03 | ○ |
| C-12 | ManageContacts, ManageAddressesページが存在 | E-01 | ○ |
| C-13 | ContactsRelationManager, AddressesRelationManager使用 | E-01 | ○ |
| C-14 | SubNavigationPosition::Top設定 | E-01 | ○ |
| C-15 | account_typeによる住所・連絡先の区別 | E-03 | ○ |
| C-16 | parent_idによる親子関係 | E-03, E-04 | ○ |
| C-17 | email_verified_atによるメール確認 | E-02 | ○ |
| C-18 | BasePartnerResourceを継承 | E-01 | ○ |
| C-19 | 機能IDはF113でウェブサイトパートナー管理 | E-05 | ○ |
| C-20 | パフォーマンス要件1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値は、ソースコードやドキュメントに明示されていない
  - 候補：非機能要件定義書 / SLAドキュメント / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - パスワード管理を含むため、セキュリティ面の確認が重要

## 6) レビュアーチェックリスト（最小）
- [ ] パスワードが正しくハッシュ化されているか確認
- [ ] $hiddenによりパスワードがシリアライズ時に除外されているか確認
- [ ] 連絡先・住所のaccount_typeによる区別が正しく動作するか確認
- [ ] parent_idによる親子関係が正しく管理されているか確認
- [ ] FilamentUserのcanAccessPanel()が適切に実装されているか確認
- [ ] 権限制御（Filament Shield）が適切に設定されているか確認
