---
generated_at: 2025-12-26 23:25:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：F012-見積書管理機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠が不明
  2. **PDF出力機能**：コード内での実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource.php`
- E-02: `plugins/webkul/sales/src/Models/Order.php`
- E-03: `plugins/webkul/sales/src/Models/OrderLine.php`
- E-04: `plugins/webkul/sales/database/migrations/2025_02_05_053212_create_sales_orders_table.php`
- E-05: `plugins/webkul/sales/src/Enums/OrderState.php`
- E-06: `plugins/webkul/sales/src/Enums/InvoiceStatus.php`
- E-07: `plugins/webkul/sales/src/Livewire/Summary.php`
- E-08: `plugins/webkul/sales/src/Settings/QuotationAndOrderSettings.php`
- E-09: `plugins/webkul/sales/src/Settings/PriceSettings.php`
- E-10: `plugins/webkul/sales/src/Settings/ProductSettings.php`
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QuotationResourceはOrderモデルを使用 | E-01 (protected static ?string $model = Order::class) | ○ |
| C-02 | partner_idは必須フィールド | E-01 (->required()) | ○ |
| C-03 | validity_dateのデフォルトは設定から取得 | E-01 (->default(fn (QuotationAndOrderSettings $settings) => now()->addDays($settings->default_quotation_validity))) | ○ |
| C-04 | date_orderのデフォルトは現在日 | E-01 (->default(now())) | ○ |
| C-05 | 見積番号はSO/{id}形式 | E-02 ($this->name = 'SO/'.$this->id) | ○ |
| C-06 | OrderStateはdraft/sent/sale/cancelを含む | E-05 | ○ |
| C-07 | 商品明細はlinesリレーションで管理 | E-02 (hasMany(OrderLine::class)) | ○ |
| C-08 | ソフトデリート対応 | E-02 (use SoftDeletes), E-04 ($table->softDeletes()) | ○ |
| C-09 | 金額計算はTax Facadeを使用 | E-01 (Tax::collect($taxIds, $subTotal, $quantity)) | ○ |
| C-10 | Summaryコンポーネントで金額表示 | E-01 (Livewire::make(Summary::class, ...)) | ○ |
| C-11 | locked状態での編集制限 | E-01 (->disabled(fn ($record): bool => $record?->locked)) | ○ |
| C-12 | キャンセル状態での操作制限 | E-01 (in_array($record?->state, [OrderState::CANCEL])) | ○ |
| C-13 | 商品重複選択の防止 | E-01 (disableOptionWhen callback with duplicate check) | ○ |
| C-14 | 削除済み商品の選択不可 | E-01 (->disableOptionWhen(fn ($label) => str_contains($label, ' (Deleted)'))) | ○ |
| C-15 | SALE状態での削除不可 | E-01 (->hidden(fn (Model $record) => $record->state == OrderState::SALE)) | ○ |
| C-16 | オプション商品のリピーター | E-01 (getOptionalProductRepeater method) | ○ |
| C-17 | 商品リピーターの削除確認 | E-01 (->deleteAction(fn (Action $action) => $action->requiresConfirmation())) | ○ |
| C-18 | UOM数量換算の計算 | E-01 (calculateUnitQuantity method) | ○ |
| C-19 | マージン計算の実装 | E-01 (calculateMargin method) | ○ |
| C-20 | パッケージング機能の条件表示 | E-01 (->visible(fn (ProductSettings $settings) => $settings->enable_packagings)) | ○ |
| C-21 | 割引機能の条件表示 | E-01 (->visible(fn (Settings\PriceSettings $settings) => $settings->enable_discount)) | ○ |
| C-22 | マージン機能の条件表示 | E-01 (->visible(fn (PriceSettings $settings) => $settings->enable_margin)) | ○ |
| C-23 | 顧客選択時の関連情報自動設定 | E-01 (afterStateUpdated for partner_id) | ○ |
| C-24 | 会社選択時の通貨自動設定 | E-01 (afterStateUpdated for company_id) | ○ |
| C-25 | ProgressStepperによる状態表示 | E-01 (ProgressStepper::make('state')) | ○ |
| C-26 | タグ管理機能 | E-01 (Select::make('sales_order_tags')->relationship('tags', 'name')->multiple()) | ○ |
| C-27 | UTMトラッキング情報の管理 | E-01 (campaign_id, medium_id, utm_source_id fields) | ○ |
| C-28 | 配送管理ページ | E-01 (ManageDeliveries::route('/{record}/deliveries')) | ○ |
| C-29 | 請求書管理ページ | E-01 (ManageInvoices::route('/{record}/invoices')) | ○ |
| C-30 | グループ化機能 | E-01 (tables groups definition) | ○ |
| C-31 | フィルター機能 | E-01 (QueryBuilder with constraints) | ○ |
| C-32 | 一括操作機能 | E-01 (BulkActionGroup with delete/restore actions) | ○ |
| C-33 | Eager loading for currency | E-01 (->modifyQueryUsing(fn (Builder $query) => $query->with('currency'))) | ○ |
| C-34 | パフォーマンス要件の具体的数値 | **根拠なし** | △ |
| C-35 | PDF出力機能 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値根拠
  - 候補：性能テスト結果 / 要件定義書 / SLA文書
- PDF出力機能の実装詳細
  - 候補：PdfController / ReportService（現状未確認）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の設計内容は根拠あり
- 1: 中リスク - パフォーマンス要件は実測が必要
- 0: 低リスク - セキュリティ考慮事項はLaravel標準機能で対応

## 6) レビュアーチェックリスト（最小）
- [ ] 金額計算ロジックがTax::collectと一致しているか確認
- [ ] 状態遷移（draft→sale→cancel）が正しく制御されているか確認
- [ ] OrderPolicyの権限定義を確認
- [ ] 明細の一括更新トランザクションを確認
