---
generated_at: 2025-12-26 23:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F013-受注管理機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）：特になし
- 備考：OrderResourceはQuotationResourceを継承・再利用する設計のため、高い信頼度

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/OrderResource.php`
- E-02: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource.php`
- E-03: `plugins/webkul/sales/src/Models/Order.php`
- E-04: `plugins/webkul/sales/src/Enums/OrderState.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OrderResourceはOrderモデルを使用 | E-01 (protected static ?string $model = Order::class) | ○ |
| C-02 | state=SALEでフィルタ | E-01 ($query->where('state', OrderState::SALE)) | ○ |
| C-03 | QuotationResourceのformを再利用 | E-01 (QuotationResource::form($schema)) | ○ |
| C-04 | QuotationResourceのtableを再利用 | E-01 (QuotationResource::table($table)->modifyQueryUsing(...)) | ○ |
| C-05 | QuotationResourceのinfolistを再利用 | E-01 (QuotationResource::infolist($schema)) | ○ |
| C-06 | サブナビゲーション4タブ構成 | E-01 ([ViewOrder, EditOrder, ManageInvoices, ManageDeliveries]) | ○ |
| C-07 | ページ定義（index/create/view/edit/invoices/deliveries） | E-01 (getPages method) | ○ |
| C-08 | navigationSort = 2 | E-01 (protected static ?int $navigationSort = 2) | ○ |
| C-09 | Ordersクラスタに所属 | E-01 (protected static ?string $cluster = Orders::class) | ○ |
| C-10 | recordTitleAttribute = name | E-01 (protected static ?string $recordTitleAttribute = 'name') | ○ |
| C-11 | id降順でソート | E-01 (->orderByDesc('id')) | ○ |
| C-12 | 受注番号はSO/{id}形式 | E-03 ($this->name = 'SO/'.$this->id) | ○ |
| C-13 | 機能一覧.csvに記載あり | E-05 (F013) | ○ |
| C-14 | ManageInvoicesページ定義 | E-01 ('invoices' => ManageInvoices::route('/{record}/invoices')) | ○ |
| C-15 | ManageDeliveriesページ定義 | E-01 ('deliveries' => ManageDeliveries::route('/{record}/deliveries')) | ○ |

## 4) 不足情報（Unknown / Missing）
なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の設計内容はすべて根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] QuotationResourceとの整合性を確認
- [ ] ManageInvoices/ManageDeliveriesの実装を確認
- [ ] state=SALEフィルタが適切に動作しているか確認
