---
generated_at: 2025-12-26 23:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F014-顧客管理機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）：特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/CustomerResource.php`
- E-02: `plugins/webkul/invoices/src/Filament/Clusters/Customer/Resources/PartnerResource.php`
- E-03: `plugins/webkul/sales/src/Models/Partner.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CustomerResourceはBaseCustomerResourceを継承 | E-01 (extends BaseCustomerResource) | ○ |
| C-02 | Partnerモデルを使用 | E-01 (protected static ?string $model = Partner::class) | ○ |
| C-03 | Ordersクラスタに所属 | E-01 (protected static ?string $cluster = Orders::class) | ○ |
| C-04 | navigationSort = 3 | E-01 (protected static ?int $navigationSort = 3) | ○ |
| C-05 | カードグリッドレイアウト | E-01 (->contentGrid(['sm' => 1, 'md' => 2, 'xl' => 3, '2xl' => 3])) | ○ |
| C-06 | サブナビゲーション5タブ | E-01 ([ViewCustomer, EditCustomer, ManageContacts, ManageAddresses, ManageBankAccounts]) | ○ |
| C-07 | ページ定義7種 | E-01 (getPages method with 7 routes) | ○ |
| C-08 | users-heroicon使用 | E-01 (protected static string|BackedEnum|null $navigationIcon = 'heroicon-o-users') | ○ |
| C-09 | ナビゲーション登録有効 | E-01 (protected static bool $shouldRegisterNavigation = true) | ○ |
| C-10 | BaseCustomerResourceのtable再利用 | E-01 (BaseCustomerResource::table($table)) | ○ |
| C-11 | ManageContactsページ定義 | E-01 ('contacts' => ManageContacts::route('/{record}/contacts')) | ○ |
| C-12 | ManageAddressesページ定義 | E-01 ('addresses' => ManageAddresses::route('/{record}/addresses')) | ○ |
| C-13 | ManageBankAccountsページ定義 | E-01 ('bank-account' => ManageBankAccounts::route('/{record}/bank-accounts')) | ○ |
| C-14 | 機能一覧.csvに記載あり | E-04 (F014) | ○ |

## 4) 不足情報（Unknown / Missing）
なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の設計内容はすべて根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] BaseCustomerResource（Invoice）との整合性を確認
- [ ] SalesプラグインのPartnerモデルの定義を確認
- [ ] 連絡先・住所・銀行口座のリレーション管理を確認
