---
generated_at: 2025-12-26 23:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F017-販売チーム管理機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）：特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Configuration/Resources/TeamResource.php`
- E-02: `plugins/webkul/sales/src/Models/Team.php`
- E-03: `plugins/webkul/sales/database/migrations/2025_01_28_061110_create_sales_teams_table.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TeamResourceはTeamモデルを使用 | E-01 (protected static ?string $model = Team::class) | ○ |
| C-02 | Configurationクラスタに所属 | E-01 (protected static ?string $cluster = Configuration::class) | ○ |
| C-03 | ナビゲーション非表示 | E-01 (protected static bool $shouldRegisterNavigation = false) | ○ |
| C-04 | users-heroicon使用 | E-01 (protected static string|BackedEnum|null $navigationIcon = 'heroicon-o-users') | ○ |
| C-05 | nameは必須フィールド | E-01 (TextInput::make('name')->required()) | ○ |
| C-06 | invoiced_targetのデフォルト値は0 | E-01 (->default(0)) | ○ |
| C-07 | invoiced_targetの最大値99999999999 | E-01 (->maxValue(99999999999)) | ○ |
| C-08 | ColorPickerでチームカラー設定 | E-01 (ColorPicker::make('color')) | ○ |
| C-09 | メンバー多対多関係 | E-01 (->relationship('members', 'name')->multiple()) | ○ |
| C-10 | is_activeトグル | E-01 (Toggle::make('is_active')) | ○ |
| C-11 | ソフトデリート対応 | E-02 (use SoftDeletes) | ○ |
| C-12 | sales_teamsテーブル使用 | E-02 (protected $table = 'sales_teams') | ○ |
| C-13 | SortableTrait使用 | E-02 (use SortableTrait) | ○ |
| C-14 | HasChatter使用 | E-02 (use HasChatter) | ○ |
| C-15 | HasLogActivity使用 | E-02 (use HasLogActivity) | ○ |
| C-16 | ページ定義4種 | E-01 (getPages method with 4 routes) | ○ |
| C-17 | 削除・復元・完全削除アクション | E-01 (DeleteAction, RestoreAction, ForceDeleteAction) | ○ |
| C-18 | 一括削除・復元アクション | E-01 (DeleteBulkAction, RestoreBulkAction, ForceDeleteBulkAction) | ○ |
| C-19 | グループ化機能 | E-01 (Groups definition) | ○ |
| C-20 | フィルター機能（QueryBuilder） | E-01 (QueryBuilder with constraints) | ○ |
| C-21 | reorderable機能 | E-01 (->reorderable('sort', 'desc')) | ○ |
| C-22 | 機能一覧.csvに記載あり | E-04 (F017) | ○ |

## 4) 不足情報（Unknown / Missing）
なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の設計内容はすべて根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] TeamPolicyの権限定義を確認
- [ ] sales_team_membersテーブルの構造を確認
- [ ] 見積・受注との連携（team_id外部キー）を確認
