---
generated_at: 2025-12-26 12:05:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート: ユーザー管理機能設計書

## 1. 概要

本レポートは「ユーザー管理」機能設計書の各記述について、ソースコードからの根拠を示すものである。

## 2. 根拠一覧

### 2.1 機能概要の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| ユーザー一覧表示機能 | plugins/webkul/security/src/Filament/Resources/UserResource/Pages/ListUsers.php | `class ListUsers extends ListRecords` | 高 |
| タブ切り替え（全件/アーカイブ） | 同上 | `getTabs()` メソッドで 'all' と 'archived' タブ定義 | 高 |
| ユーザー招待機能 | 同上 | `inviteUser` アクション定義 | 高 |
| 招待メール送信 | 同上 | `Mail::to($invitation->email)->send(new UserInvitationMail($invitation))` | 高 |

### 2.2 ビジネスルールの根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| Partner自動作成 | plugins/webkul/security/src/Models/User.php | `static::saved` ブートイベント内 `handlePartnerCreation` | 高 |
| Partner自動更新 | 同上 | `handlePartnerUpdation` メソッド | 高 |
| SoftDelete対応 | 同上 | `use SoftDeletes` トレイト使用 | 高 |
| デフォルト会社チェック | ListUsers.php | `if (! isset(app(UserSettings::class)->default_company_id))` | 高 |

### 2.3 データ構造の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| partner_idカラム | plugins/webkul/security/src/Models/User.php | `$this->mergeFillable(['partner_id', ...])` | 高 |
| languageカラム | 同上 | fillableに'language'定義 | 高 |
| is_activeカラム | 同上 | fillableに'is_active'定義 | 高 |
| default_company_idカラム | 同上 | fillableに'default_company_id'定義、castsで'integer' | 高 |
| resource_permissionカラム | 同上 | fillableに'resource_permission'定義 | 高 |
| is_defaultカラム | 同上 | fillableに'is_default'定義 | 高 |

### 2.4 リレーションの根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| teams関係 | plugins/webkul/security/src/Models/User.php | `public function teams(): BelongsToMany` | 高 |
| companies関係 | 同上 | `public function companies(): HasMany` | 高 |
| partner関係 | 同上 | `public function partner()` - belongsTo | 高 |
| allowedCompanies関係 | 同上 | `public function allowedCompanies(): BelongsToMany` | 高 |
| defaultCompany関係 | 同上 | `public function defaultCompany(): BelongsTo` | 高 |

### 2.5 クラス構成の根拠

| 記述内容 | 根拠ファイル | 確認方法 | 信頼度 |
|----------|--------------|----------|--------|
| UserResource | plugins/webkul/security/src/Filament/Resources/UserResource.php | ファイル存在確認 | 高 |
| ListUsers | plugins/webkul/security/src/Filament/Resources/UserResource/Pages/ListUsers.php | ファイル存在確認 | 高 |
| CreateUser | plugins/webkul/security/src/Filament/Resources/UserResource/Pages/CreateUser.php | ファイル存在確認 | 高 |
| User Model | plugins/webkul/security/src/Models/User.php | ファイル存在確認 | 高 |

## 3. ソースコード参照

### User.php（Partner連携部分）
```php
// plugins/webkul/security/src/Models/User.php
protected static function boot()
{
    parent::boot();

    static::saved(function ($user) {
        if (! $user->partner_id) {
            $user->handlePartnerCreation($user);
        } else {
            $user->handlePartnerUpdation($user);
        }
    });
}

private function handlePartnerCreation(self $user)
{
    $partner = $user->partner()->create([
        'creator_id' => Auth::user()->id ?? $user->id,
        'user_id'    => $user->id,
        'sub_type'   => 'partner',
        ...Arr::except($user->toArray(), ['id']),
    ]);

    $user->partner_id = $partner->id;
    $user->save();
}
```

### ListUsers.php（招待機能）
```php
// plugins/webkul/security/src/Filament/Resources/UserResource/Pages/ListUsers.php
Action::make('inviteUser')
    ->visible(fn (UserSettings $userSettings) => $userSettings->enable_user_invitation)
    ->action(function ($data) {
        if (! isset(app(UserSettings::class)->default_company_id)) {
            Notification::make('invitedFailed')
                ->title(__('...default-company-error.title'))
                ->danger()
                ->send();
            return;
        }

        $invitation = Invitation::create(['email' => $data['email']]);
        Mail::to($invitation->email)->send(new UserInvitationMail($invitation));
    })
```

## 4. 根拠のない記述

| 記述内容 | 理由 | 推奨対応 |
|----------|------|----------|
| 非同期処理推奨 | 実装コードでは同期処理確認、非同期化は推奨事項 | 設計ガイドラインとして記載 |

## 5. 信頼度評価

- **高信頼度（24件）**: ソースコードから直接確認できる記述
- **低信頼度（1件）**: 非機能要件の推奨事項

**総合信頼度: 96%**
