---
generated_at: 2025-12-26 23:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：F022-タグ管理(販売)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Configuration/Resources/TagResource.php`
- E-02: `plugins/webkul/sales/src/Models/Tag.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TagResourceはFilament Resourceを継承 | E-01（24行目） | ○ |
| C-02 | モデルはSale\Models\Tagを使用 | E-01（26行目）, E-02 | ○ |
| C-03 | テーブル名はsales_tags | E-02（13行目） | ○ |
| C-04 | fillableにname, color, creator_id | E-02（15-19行目） | ○ |
| C-05 | TextInputでnameを入力 | E-01（51-54行目） | ○ |
| C-06 | ColorPickerでcolorを入力 | E-01（55-57行目） | ○ |
| C-07 | nameは必須入力 | E-01（53行目） | ○ |
| C-08 | colorはhexColor形式 | E-01（57行目） | ○ |
| C-09 | 一覧でTextColumn/ColorColumn表示 | E-01（64-72行目） | ○ |
| C-10 | searchable, sortable対応 | E-01（66-67行目） | ○ |
| C-11 | ViewAction, EditAction, DeleteAction対応 | E-01（74-89行目） | ○ |
| C-12 | BulkActionGroupで一括削除 | E-01（92-100行目） | ○ |
| C-13 | ListTagsページで一覧管理 | E-01（106行目） | ○ |
| C-14 | Infolistで詳細表示対応 | E-01（111-121行目） | ○ |
| C-15 | createdByリレーションあり | E-02（21-24行目） | ○ |
| C-16 | 機能IDはF022 | E-03 | ○ |
| C-17 | 画面IDはSCR-SALES-005 | E-04 | ○ |
| C-18 | パフォーマンス要件1秒/2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は要件定義書等で確認が必要
  - 候補：要件定義書 / 非機能要件定義書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単純なマスタ管理機能でリスクは低い
- 1: 中リスク - パフォーマンス要件は推定値のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] タグが使用中の場合の削除制御の実装を確認
- [ ] 多言語対応のラベル定義を確認
- [ ] パフォーマンス要件の妥当性を確認
