---
generated_at: 2025-12-26 23:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：F023-活動タイプ管理(販売)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **入力パラメータ詳細**：BaseActivityTypeResourceの実装確認が必要
  2. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Configuration/Resources/ActivityTypeResource.php`
- E-02: `plugins/webkul/sales/src/Models/ActivityType.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BaseActivityTypeResourceを継承 | E-01（12行目） | ○ |
| C-02 | モデルはSale\Models\ActivityTypeを使用 | E-01（15行目）, E-02 | ○ |
| C-03 | BaseActivityTypeはSupport\Models\ActivityTypeを継承 | E-02 | ○ |
| C-04 | Configurationクラスターに所属 | E-01（19行目） | ○ |
| C-05 | ナビゲーショングループはActivities | E-01（27行目） | ○ |
| C-06 | getModelLabelはActivity Type | E-01（22行目） | ○ |
| C-07 | List/Create/Edit/Viewページ構成 | E-01（31-38行目） | ○ |
| C-08 | 機能IDはF023 | E-03 | ○ |
| C-09 | 画面IDはSCR-SALES-007 | E-04 | ○ |
| C-10 | shouldRegisterNavigation = true | E-01（17行目） | ○ |
| C-11 | 機能カテゴリは販売管理 | E-03 | ○ |
| C-12 | 種別は業務 | E-03 | ○ |
| C-13 | 関連リソースはActivityTypeResource | E-03 | ○ |
| C-14 | テーブル名はsupport_activity_types | E-02（継承元から推定） | ○ |
| C-15 | 入力パラメータ詳細（default_days等） | **要確認**（継承元の実装依存） | △ |
| C-16 | パフォーマンス要件1秒/2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- BaseActivityTypeResourceの詳細実装を確認する必要あり
  - 候補：`plugins/webkul/support/src/Filament/Resources/ActivityTypeResource.php`
- パフォーマンス要件の具体的数値は要件定義書等で確認が必要

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 継承元の実装に依存する部分があり、詳細確認が必要
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] BaseActivityTypeResourceの実装詳細を確認
- [ ] support_activity_typesテーブルのスキーマを確認
- [ ] plugin='sales'でのフィルタリング実装を確認
- [ ] パフォーマンス要件の妥当性を確認
