---
generated_at: 2025-12-26 23:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：F024-活動プラン管理(販売)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Configuration/Resources/ActivityPlanResource.php`
- E-02: `plugins/webkul/sales/src/Models/ActivityPlan.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ActivityPlanResourceはFilament Resourceを継承 | E-01（43行目） | ○ |
| C-02 | モデルはSale\Models\ActivityPlanを使用 | E-01（45行目）, E-02 | ○ |
| C-03 | TextInputでnameを入力（必須） | E-01（67-70行目） | ○ |
| C-04 | Selectでcompany_idを入力 | E-01（71-77行目） | ○ |
| C-05 | Toggleでis_activeを入力（デフォルトtrue） | E-01（78-81行目） | ○ |
| C-06 | plugin='sales'でクエリフィルタリング | E-01（268-270行目） | ○ |
| C-07 | CreateAction時にplugin='sales'設定 | E-01（253行目） | ○ |
| C-08 | creator_id自動設定 | E-01（255行目） | ○ |
| C-09 | company_id未指定時デフォルト会社設定 | E-01（257行目） | ○ |
| C-10 | reorderableColumns対応 | E-01（90行目） | ○ |
| C-11 | TernaryFilterでis_activeフィルタ | E-01（124-125行目） | ○ |
| C-12 | QueryBuilderで高度なフィルタリング | E-01（126-175行目） | ○ |
| C-13 | グループ化機能（name, createdBy等） | E-01（177-194行目） | ○ |
| C-14 | ViewAction, EditAction対応 | E-01（196-199行目） | ○ |
| C-15 | RestoreAction対応 | E-01（200-206行目） | ○ |
| C-16 | DeleteAction対応 | E-01（207-213行目） | ○ |
| C-17 | ForceDeleteAction対応 | E-01（214-220行目） | ○ |
| C-18 | 一括操作（Restore, Delete, ForceDelete） | E-01（223-245行目） | ○ |
| C-19 | ActivityTemplateRelationManager使用 | E-01（39行目, 304-308行目） | ○ |
| C-20 | List/View/Editページ構成 | E-01（311-318行目） | ○ |
| C-21 | Infolistで詳細表示 | E-01（273-302行目） | ○ |
| C-22 | ナビゲーションアイコンはheroicon-o-briefcase | E-01（47行目） | ○ |
| C-23 | 機能IDはF024 | E-03 | ○ |
| C-24 | 画面IDはSCR-SALES-008 | E-04 | ○ |
| C-25 | パフォーマンス要件1秒/2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は要件定義書等で確認が必要
  - 候補：要件定義書 / 非機能要件定義書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから詳細に検証できている
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] ActivityTemplateRelationManagerの実装詳細を確認
- [ ] support_activity_plansテーブルのスキーマを確認
- [ ] ソフトデリート時の関連データ処理を確認
- [ ] パフォーマンス要件の妥当性を確認
