---
generated_at: 2025-12-26 23:20:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：F025-発注書管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし
  2. **PDF生成時間**：5秒以内の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource.php`
- E-02: `plugins/webkul/purchases/src/Models/Order.php`
- E-03: `plugins/webkul/purchases/src/Enums/OrderState.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OrderResourceはFilament Resourceを継承 | E-01（72行目） | ○ |
| C-02 | モデルはPurchase\Models\Orderを使用 | E-01（76行目）, E-02 | ○ |
| C-03 | テーブル名はpurchases_orders | E-02（37行目） | ○ |
| C-04 | ProgressStepperでstate表示 | E-01（86-103行目） | ○ |
| C-05 | state: draft/sent/purchase/done/canceled | E-02（88行目）, E-03 | ○ |
| C-06 | partner_id必須・supplier限定 | E-01（108-125行目） | ○ |
| C-07 | 仕入先変更時に支払条件自動設定 | E-01（128-132行目） | ○ |
| C-08 | 仕入先価格自動適用ロジック | E-01（133-157行目） | ○ |
| C-09 | purchase/done状態で編集制限 | E-01（162行目, 216行目等） | ○ |
| C-10 | requisition_idで購買契約連携 | E-01（167-208行目） | ○ |
| C-11 | 商品RepeaterでCRUD | E-01（789-1074行目） | ○ |
| C-12 | 金額計算ロジック（calculateLineTotals） | E-01（1251-1290行目） | ○ |
| C-13 | TaxFacadeで税額計算 | E-01（1283行目） | ○ |
| C-14 | 仕入先価格取得ロジック | E-01（1206-1231行目） | ○ |
| C-15 | 最適パッケージング選択ロジック | E-01（1233-1249行目） | ○ |
| C-16 | UOM設定による表示制御 | E-01（946-960行目） | ○ |
| C-17 | パッケージング設定による表示制御 | E-01（961-984行目） | ○ |
| C-18 | Summaryコンポーネントで金額表示 | E-01（251-258行目） | ○ |
| C-19 | タブ構成（Products/Additional/Terms） | E-01（246-322行目） | ○ |
| C-20 | 発注番号は「PO/{id}」形式 | E-02（249-252行目） | ○ |
| C-21 | HasChatter, HasLogActivity対応 | E-02（30行目） | ○ |
| C-22 | HasCustomFields対応 | E-01（74行目）, E-02（30行目） | ○ |
| C-23 | 関連: partner, currency, company等 | E-02（138-186行目） | ○ |
| C-24 | lines関連（HasMany） | E-02（188-191行目） | ○ |
| C-25 | accountMoves関連 | E-02（193-196行目） | ○ |
| C-26 | operations関連（在庫連携） | E-02（203-206行目） | ○ |
| C-27 | グループ化機能対応 | E-01（401-415行目） | ○ |
| C-28 | QueryBuilderフィルタリング | E-01（416-495行目） | ○ |
| C-29 | 削除時done状態チェック | E-01（507行目） | ○ |
| C-30 | 一括削除対応 | E-01（528-545行目） | ○ |
| C-31 | 機能IDはF025 | E-04 | ○ |
| C-32 | 関連画面SCR-PURCH-002 | E-05 | ○ |
| C-33 | invoice_status, receipt_status管理 | E-02（89-90行目） | ○ |
| C-34 | パフォーマンス要件2-3秒以内 | **根拠なし** | △ |
| C-35 | PDF生成時間5秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は要件定義書等で確認が必要
- PDF生成機能の詳細実装を確認が必要
  - 候補：アクションクラス / ビューファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能はソースコードから詳細に検証できている
- 1: 中リスク - パフォーマンス要件は推定値
- 1: 中リスク - 在庫連携・請求書連携の詳細動作は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] OrderState enumの全状態を確認
- [ ] ManageReceipts, ManageBillsページの実装を確認
- [ ] 状態遷移アクション（Confirm, Cancel等）の実装を確認
- [ ] メール送信機能の実装を確認
- [ ] パフォーマンス要件の妥当性を確認
