---
generated_at: 2025-12-26 23:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：F026-見積依頼(RFQ)管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし
  2. **メール送信時間**：10秒以内の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/QuotationResource.php`
- E-02: `plugins/webkul/purchases/src/Models/Quotation.php`
- E-03: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QuotationResourceはOrderResourceを継承 | E-01（15行目） | ○ |
| C-02 | QuotationモデルはOrderを継承 | E-02 | ○ |
| C-03 | モデルはPurchase\Models\Quotationを使用 | E-01（17行目） | ○ |
| C-04 | ナビゲーションアイコンはheroicon-o-document-text | E-01（19行目） | ○ |
| C-05 | shouldRegisterNavigation = true | E-01（21行目） | ○ |
| C-06 | navigationSort = 1 | E-01（25行目） | ○ |
| C-07 | Ordersクラスターに所属 | E-01（27行目） | ○ |
| C-08 | サブナビゲーション構成（View/Edit/Bills/Receipts） | E-01（39-47行目） | ○ |
| C-09 | ページ構成（index/create/view/edit/bills/receipts） | E-01（49-58行目） | ○ |
| C-10 | ListQuotationsページで一覧表示 | E-01（52行目） | ○ |
| C-11 | CreateQuotationページで作成 | E-01（53行目） | ○ |
| C-12 | ViewQuotationページで詳細表示 | E-01（54行目） | ○ |
| C-13 | EditQuotationページで編集 | E-01（55行目） | ○ |
| C-14 | ManageBillsページで請求書管理 | E-01（56行目） | ○ |
| C-15 | ManageReceiptsページで入荷管理 | E-01（57行目） | ○ |
| C-16 | 発注書と同一テーブル（purchases_orders） | E-02, E-03 | ○ |
| C-17 | 発注番号形式「PO/{id}」 | E-03（Order.updateName()） | ○ |
| C-18 | 機能IDはF026 | E-04 | ○ |
| C-19 | 画面IDはSCR-PURCH-001 | E-05 | ○ |
| C-20 | OrderResourceのform/table/infolistを継承使用 | E-01（継承構造） | ○ |
| C-21 | パフォーマンス要件2-3秒以内 | **根拠なし** | △ |
| C-22 | メール送信時間10秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は要件定義書等で確認が必要
- メール送信機能の詳細実装を確認が必要
  - 候補：SendEmailAction / VendorPurchaseOrderMail

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 継承構造が明確でOrderResourceの機能を再利用
- 1: 中リスク - パフォーマンス・メール送信時間は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] ListQuotationsページでのstateフィルタリング条件を確認
- [ ] SendEmailActionの実装詳細を確認
- [ ] ConfirmActionの実装詳細を確認
- [ ] パフォーマンス要件の妥当性を確認
