---
generated_at: 2025-12-26 23:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：F027-仕入先管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし
  2. **BaseVendorResource詳細**：継承元の詳細実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/VendorResource.php`
- E-02: `plugins/webkul/purchases/src/Models/Partner.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VendorResourceはBaseVendorResourceを継承 | E-01（22行目） | ○ |
| C-02 | HasCustomFieldsトレイト使用 | E-01（24行目） | ○ |
| C-03 | モデルはPurchase\Models\Partnerを使用 | E-01（26行目）, E-02 | ○ |
| C-04 | ナビゲーションアイコンはheroicon-o-users | E-01（28行目） | ○ |
| C-05 | shouldRegisterNavigation = true | E-01（30行目） | ○ |
| C-06 | Ordersクラスターに所属 | E-01（32行目） | ○ |
| C-07 | navigationSort = 4 | E-01（34行目） | ○ |
| C-08 | サブナビゲーション構成 | E-01（43-52行目） | ○ |
| C-09 | ContactsRelationManager使用 | E-01（59行目） | ○ |
| C-10 | AddressesRelationManager使用 | E-01（63行目） | ○ |
| C-11 | RelationGroup機能使用 | E-01（55-66行目） | ○ |
| C-12 | ページ構成（index/create/view/edit/contacts/addresses/bills/purchases） | E-01（70-80行目） | ○ |
| C-13 | PartnerモデルはBasePartnerを継承 | E-02（9行目） | ○ |
| C-14 | ordersリレーション（HasMany） | E-02（11-14行目） | ○ |
| C-15 | accountMovesリレーション（HasMany） | E-02（16-19行目） | ○ |
| C-16 | ManageContactsページ対応 | E-01（77行目） | ○ |
| C-17 | ManageAddressesページ対応 | E-01（78行目） | ○ |
| C-18 | ManageBillsページ対応 | E-01（79行目） | ○ |
| C-19 | ManagePurchasesページ対応 | E-01（80行目） | ○ |
| C-20 | 機能IDはF027 | E-03 | ○ |
| C-21 | 画面IDはSCR-PURCH-003 | E-04 | ○ |
| C-22 | recordTitleAttribute = name | E-01（36行目） | ○ |
| C-23 | パフォーマンス要件2秒以内 | **根拠なし** | △ |
| C-24 | BaseVendorResourceの詳細実装 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は要件定義書等で確認が必要
- BaseVendorResource（Invoice\VendorResource）の詳細実装を確認が必要
  - 候補：`plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/VendorResource.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 継承構造は明確
- 1: 中リスク - 継承元の詳細機能確認が必要
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] BaseVendorResourceのform/table実装を確認
- [ ] accounts_partnersテーブルのスキーマを確認
- [ ] sub_type='supplier'のフィルタリング実装を確認
- [ ] パフォーマンス要件の妥当性を確認
