---
generated_at: 2025-12-26 23:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：F029-購買依頼管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし
  2. **RequisitionResource詳細**：画面実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/purchases/src/Models/Requisition.php`
- E-02: `plugins/webkul/purchases/src/Enums/RequisitionType.php`
- E-03: `plugins/webkul/purchases/src/Enums/RequisitionState.php`
- E-04: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource.php`（契約連携部分）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル名はpurchases_requisitions | E-01（30行目） | ○ |
| C-02 | fillable項目（name, type, state等） | E-01（37-50行目） | ○ |
| C-03 | type: RequisitionType enum | E-01（58行目）, E-02 | ○ |
| C-04 | state: RequisitionState enum | E-01（57行目）, E-03 | ○ |
| C-05 | HasChatter, HasCustomFields, HasLogActivity使用 | E-01（23行目） | ○ |
| C-06 | SoftDeletes使用 | E-01（23行目） | ○ |
| C-07 | partnerリレーション | E-01（77-80行目） | ○ |
| C-08 | currencyリレーション | E-01（82-85行目） | ○ |
| C-09 | userリレーション | E-01（87-90行目） | ○ |
| C-10 | companyリレーション | E-01（92-95行目） | ○ |
| C-11 | creatorリレーション | E-01（97-100行目） | ○ |
| C-12 | linesリレーション（HasMany） | E-01（102-105行目） | ○ |
| C-13 | 契約番号自動採番（BO/PT） | E-01（126-132行目） | ○ |
| C-14 | BLANKET_ORDERは「BO/{id}」 | E-01（128-129行目） | ○ |
| C-15 | その他は「PT/{id}」 | E-01（130-131行目） | ○ |
| C-16 | 発注書でrequisition_id選択可能 | E-04（167-208行目） | ○ |
| C-17 | 契約選択時に明細自動展開 | E-04（180-206行目） | ○ |
| C-18 | enable_purchase_agreementsで表示制御 | E-04（172行目） | ○ |
| C-19 | 機能IDはF029 | E-05 | ○ |
| C-20 | 画面IDはSCR-PURCH-004相当 | E-06（購買契約関連） | ○ |
| C-21 | パフォーマンス要件2秒以内 | **根拠なし** | △ |
| C-22 | RequisitionResource実装詳細 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は要件定義書等で確認が必要
- PurchaseAgreementResourceの詳細実装を確認が必要
  - 候補：`plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseAgreementResource.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モデル構造は明確
- 1: 中リスク - 画面実装の詳細確認が必要
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] PurchaseAgreementResourceの実装詳細を確認
- [ ] purchases_requisition_linesテーブルのスキーマを確認
- [ ] 発注書作成時の明細展開ロジックを確認
- [ ] enable_purchase_agreements設定の動作を確認
- [ ] パフォーマンス要件の妥当性を確認
