---
generated_at: 2025-12-26 23:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：31-仕入先価格管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **有効期間チェックロジック**：発注連携時の具体的な実装確認要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Configurations/Resources/VendorPriceResource.php`
- E-02: `plugins/webkul/products/src/Models/ProductSupplier.php`
- E-03: `plugins/webkul/purchases/src/Models/ProductSupplier.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` (F031行)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (SCR-PURCH-006行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProductSupplierモデルを使用 | E-01, E-02, E-03 | ○ |
| C-02 | partner_id（仕入先ID）が必須項目 | E-01 (L61-69) | ○ |
| C-03 | currency_idが必須項目 | E-01 (L119-125) | ○ |
| C-04 | product_nameは最大255文字 | E-01 (L70-73) | ○ |
| C-05 | product_codeは最大255文字 | E-01 (L74-77) | ○ |
| C-06 | delayのデフォルト値は1 | E-01 (L78-84) | ○ |
| C-07 | min_qtyのデフォルト値は0 | E-01 (L103-109) | ○ |
| C-08 | priceのデフォルト値は0 | E-01 (L112-118) | ○ |
| C-09 | discountのデフォルト値は0 | E-01 (L136-141) | ○ |
| C-10 | テーブル名はproducts_product_suppliers | E-02 (L22) | ○ |
| C-11 | 通貨デフォルトはユーザーのデフォルト会社通貨 | E-01 (L124) | ○ |
| C-12 | 会社デフォルトはユーザーのデフォルト会社 | E-01 (L146) | ○ |
| C-13 | 一覧画面でフィルタ機能あり | E-01 (L224-330) | ○ |
| C-14 | 一覧画面でグループ化機能あり | E-01 (L211-223) | ○ |
| C-15 | 削除アクションあり | E-01 (L360-377) | ○ |
| C-16 | 一括削除アクションあり | E-01 (L380-397) | ○ |
| C-17 | 表示/編集/削除のレコードアクションあり | E-01 (L357-377) | ○ |
| C-18 | 有効期間（starts_at, ends_at）を管理 | E-01 (L126-133), E-02 (L36-37, 47-50) | ○ |
| C-19 | Sortableトレイト使用で並び順管理 | E-02 (L16, 52-55) | ○ |
| C-20 | 商品は非コンフィグ商品のみ選択可能 | E-01 (L94-102) | ○ |
| C-21 | 機能カテゴリは購買管理 | E-04 | ○ |
| C-22 | 関連リソースはVendorPriceResource | E-04, E-05 | ○ |
| C-23 | SCR-PURCH-006が画面ID | E-05 | ○ |
| C-24 | パフォーマンス要件（1秒/2秒） | **根拠なし** | △ |
| C-25 | 発注時の有効期間チェック実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値は設計書・要件定義書が見つからない
  - 候補：非機能要件定義書 / システム性能要件書 / SLA文書
- 発注書作成時の仕入先価格自動適用ロジックの詳細実装
  - 候補：OrderResource.php / QuotationResource.php の価格計算処理

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：基本的なCRUD機能は全てコードで確認済み
- 1（中リスク）：発注連携時の価格適用ロジックは別機能との統合テストで確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 入力パラメータのバリデーションルールがコードと一致しているか確認
- [ ] テーブル定義（products_product_suppliers）のカラムと設計書が一致しているか確認
- [ ] 削除時の外部キー制約エラー処理が適切に動作するか確認
- [ ] パフォーマンス要件の妥当性を関係者と合意
