---
generated_at: 2025-12-26 23:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：32-商品属性管理(購買)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **オプション50件以上の処理時間**：具体的なテスト結果なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Configurations/Resources/ProductAttributeResource.php`
- E-02: `plugins/webkul/products/src/Filament/Resources/AttributeResource.php`
- E-03: `plugins/webkul/products/src/Models/Attribute.php`（推定）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` (F032行)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (SCR-PURCH-008行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AttributeResourceを継承している | E-01 (L14) | ○ |
| C-02 | ProductSettings.enable_variantsで機能有効化 | E-01 (L28-35) | ○ |
| C-03 | name属性は必須で最大255文字 | E-02 (L51-53) | ○ |
| C-04 | type属性は必須でAttributeType列挙型 | E-02 (L54-59) | ○ |
| C-05 | デフォルトタイプはRADIO | E-02 (L58) | ○ |
| C-06 | typeがCOLORの場合のみカラーピッカー表示 | E-02 (L75-77) | ○ |
| C-07 | extra_priceのデフォルトは0 | E-02 (L79-84) | ○ |
| C-08 | optionsはRepeaterで管理 | E-02 (L64-86) | ○ |
| C-09 | ソフトデリート対応 | E-02 (L132-167) | ○ |
| C-10 | 復元アクションあり | E-02 (L136-142) | ○ |
| C-11 | 完全削除アクションあり | E-02 (L150-167) | ○ |
| C-12 | 一括削除アクションあり | E-02 (L178-184) | ○ |
| C-13 | 一括復元アクションあり | E-02 (L171-177) | ○ |
| C-14 | タイプでフィルタ可能 | E-02 (L124-129) | ○ |
| C-15 | タイプでグループ化可能 | E-02 (L112-122) | ○ |
| C-16 | 機能カテゴリは購買管理 | E-04 | ○ |
| C-17 | クラスターはConfigurations | E-01 (L24) | ○ |
| C-18 | ナビゲーションソートは9 | E-01 (L22) | ○ |
| C-19 | パフォーマンス要件（1秒/2秒） | **根拠なし** | △ |
| C-20 | オプション50件以上で3秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値は設計書・要件定義書が見つからない
  - 候補：非機能要件定義書 / システム性能要件書 / SLA文書
- Attributeモデルの詳細定義（テーブル名、カラム構成）
  - 候補：products/src/Models/Attribute.php / データベースマイグレーション

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：基本的なCRUD機能は親クラス（AttributeResource）で確認済み
- 1（中リスク）：購買モジュール固有のカスタマイズが将来追加される可能性

## 6) レビュアーチェックリスト（最小）
- [ ] ProductAttributeResourceが正しくAttributeResourceを継承しているか確認
- [ ] enable_variants設定による表示制御が正しく動作するか確認
- [ ] 購買モジュール固有のAttributeモデルが正しく参照されているか確認
- [ ] オプションの追加/削除がリレーション管理で正しく動作するか確認
